#!/bin/bash

# set_time.sh
# Setzt die Uhrzeit auf einem Raspberry Pi ohne Internetverbindung

if [ "$#" -ne 1 ]; then
  echo "Usage: $0 <YYYY-MM-DD HH:MM:SS>"
  exit 1
fi

TIME_STRING=$1

# Setze die Systemzeit mit dem 'date'-Befehl
sudo date -s "$TIME_STRING"

if [ $? -eq 0 ]; then
  echo "Time successfully set to $TIME_STRING"
else
  echo "Error: Could not set time"
  exit 1
fi
