const httpSetNumber = new XMLHttpRequest();

/**
 * The `setStationNumber` function validates input values, constructs a URL with parameters, sends a
 * GET request using XMLHttpRequest, displays a waiting modal, and changes the host address after a set
 * interval.
 * @returns The `setStationNumber` function is returning nothing explicitly. It either completes its
 * execution without any explicit return value or it may return `undefined` implicitly.
 */
function setStationNumber() {
  // Holen der eingegebenen Seriennummer
  const number = document.getElementById('serialnumber').value;

  // Holen des ausgewählten Box-Typs
  const selectElement = document.getElementById("boxtyp");
  const boxtyp = selectElement.selectedOptions[0].value;

  // Überprüfen, ob number und boxtyp Werte enthalten
  if (!number || !boxtyp) {
    alert("Please enter a serial number and select which system you are using.\n\nYou will find this on the underside of the Velobox or on the back of the SmartCube.");
    return; // Funktion wird gestoppt, wenn Werte fehlen
  }

  // Überprüfen, ob number eine 3- oder 4-stellige Zahl zwischen 100 und 9999 ist
  if (!/^\d{3,4}$/.test(number) || number < 100 || number > 99999) {
    alert("Please enter a valid 3- or 5-digit serial number between 100 and 99999.");
    return; // Funktion wird gestoppt, wenn die Seriennummer ungültig ist
  }

  // Erstellen der URL mit den Parametern
  const url = `/set_stationsnummer.tcls?number=${number}&boxtyp=${boxtyp}`;
  
  // Erstellen des XMLHttpRequest-Objekts
  //var httpSetNumber = new XMLHttpRequest();
  
  // Öffnen der Verbindung
  httpSetNumber.open("GET", url, true);
  
  // Senden der Anfrage
  httpSetNumber.send();
  
  // Anzeigen des Wartemodals
  UIkit.modal('#modal-wait').show();
  
  // Intervall setzen, um die Host-Adresse zu ändern
  const inter = setInterval(() => {
      location.host = `${boxtyp + number}.local`;
      clearInterval(inter);
  }, 30000);
}
