#!/bin/bash

# Parameter prüfen
if [ -z "$1" ] || [ -z "$2" ]; then
  echo "Usage: $0 <Stationsnummer> <Boxtyp: velobox|smartcube>"
  exit 1
fi

STATION_NR="$1"
BOXTYPE="$2"
NEWHOSTNAME="${BOXTYPE}${STATION_NR}"

echo "Stationsnummer: $STATION_NR"
echo "Boxtyp: $BOXTYPE"
echo "Neuer Hostname: $NEWHOSTNAME"

# 1. vmkstationd.conf anpassen
VMKCONF="/usr/local/etc/vmkstationd.conf"
if [ -f "$VMKCONF" ]; then
  sed -i "s/set STATION_NR .*/set STATION_NR $STATION_NR/" "$VMKCONF"
else
  echo "Warnung: $VMKCONF nicht gefunden"
fi

# 2. hostname-Datei anpassen
if [ -f "/etc/hostname" ]; then
  OLDHOSTNAME=$(cat /etc/hostname)
  echo "$NEWHOSTNAME" > /etc/hostname
else
  echo "Fehler: /etc/hostname nicht gefunden"
  exit 1
fi

# 3. /etc/hosts anpassen
if [ -f "/etc/hosts" ]; then
  sed -i "s/$OLDHOSTNAME/$NEWHOSTNAME/g" /etc/hosts
  sed -i "s/raspberrypi/$NEWHOSTNAME/g" /etc/hosts
else
  echo "Fehler: /etc/hosts nicht gefunden"
  exit 1
fi

# Hinweis für den Benutzer
echo "Hostname und Konfiguration gesetzt. System wird neu gestartet..."

# Neustart
reboot
