#!/bin/bash
#
# velobox_update_3.1.3
# Kopiert das Update-Archiv ins Hauptverzeichnis und entpackt es
# Velometrik-GmbH
# Breunsdorfer Str. 48a
# 04575 Neukieritzsch
#
# www.velometrik.com
# support@velometrik.de
#
# Historie:
# 12.07.2023    Peter Bauer    erstellt
# 10.12.2024    Peter Bauer    überarbeitet
# 19.12.2024    Peter Bauer    überarbeitet
# 21.02.2025    Peter Bauer    Update auf 3.1.3
# 13.03.2025    Peter Bauer    Update auf 3.1.4
# 25.07.2025    Peter Bauer    Update auf 3.1.5 reg script

LAST_VERSION="3.1.4"
CURRENT_VERSION="3.1.5"
JSON_PATH="/usr/local/vmkstationd/htdocs/htdocs.json"
UPDATE_TAR="velobox_update_3.1.5.tar.gz"

if [ "$(whoami)" != "root" ]; then
    echo "ERROR"
    echo "The script must be executed by root!"
    exit 1
fi

# Extrahiere die Version aus htdocs.json und ignoriere '_dev' falls vorhanden
if [ ! -f "$JSON_PATH" ]; then
  echo "ERROR: JSON file $JSON_PATH not found!"
  exit 1
fi

VERSION=$(grep -oP '(?<="VERSION": ")[^"]*' "$JSON_PATH" | sed 's/_dev//')

# Überprüfen, ob die Version entweder LAST_VERSION oder CURRENT_VERSION entspricht
if [ "$VERSION" != "$LAST_VERSION" ] && [ "$VERSION" != "$CURRENT_VERSION" ]; then
    echo "ERROR"
    echo "Update requires VERSION $LAST_VERSION or $CURRENT_VERSION in htdocs.json"
    exit 1
fi

# Prüfen, ob die Update-Datei existiert
if [ ! -r "$UPDATE_TAR" ]; then
    echo "ERROR"
    echo "$UPDATE_TAR not found"
    exit 1
fi

# Kopiere das Archiv ins Root-Verzeichnis
cp "$UPDATE_TAR" /

if [ $? -ne 0 ]; then
    echo "ERROR: Could not copy $UPDATE_TAR to /"
    exit 1
fi

# Entpacke das Update-Archiv ins Root-Verzeichnis (enthält bereits die richtige Struktur)
cd /
tar xf "$UPDATE_TAR"

if [ $? -ne 0 ]; then
    echo "ERROR: Could not extract $UPDATE_TAR!"
    exit 1
fi

rm -f "/$UPDATE_TAR"

echo "Update erfolgreich durchgeführt. htdocs-Ordner wurde aktualisiert."

history -c

echo "Done!"
