/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/

LoadChangelog()



function LoadChangelog(){
    fetch("/production/json/changelog.json", {
        mode: "no-cors",
      }) // disable CORS because path does not contain http(s)
        .then((res) => res.json())
        .then((data) => (Changelog(data)))
}

/**
 * The function `Changelog` takes a JSON object as input and dynamically creates a changelog list on a
 * webpage based on the data in the JSON object.
 * @param jsn - It looks like the `Changelog` function is designed to generate a changelog list based
 * on the provided JSON data. The JSON data should have a structure where each key represents a version
 * number and the corresponding value contains information about that version.
 */
function Changelog(jsn) {
    let append = $('#changelog_list')
    for (const key in jsn) {
            const el = jsn[key];
            let li   = newElement({element:'li'},append)
            let div1 = newElement({element:'div',cls:['changelog-block']},li)
            let div2 = newElement({element:'div',cls:['tags']},div1)
            let a    = newElement({element:'a',cls:['tag']},div2)
            a.innerHTML = key
            let div3 = newElement({element:'div',cls:['changelog-content']},div1)
            let h2   = newElement({element:'h2',cls:['title']},div3)
            h2.innerHTML = el.head
            let div4 = newElement({element:'div',cls:['byline']},div3)
            div4.innerHTML = `Veröffentlicht am: ${el.date} von ${el.autor}`
            let div5    = newElement({element:'div',cls:['excerpt']},div3)
            let ul   = newElement({element:'ul'},div5)
            for (const n in el.change) {
                //console.log(n,el.change[n]);
                let li1 = newElement({element:'li'},ul)
                li1.innerHTML = el.change[n]
            }
            //div5.innerHTML = el.change
            
    }
}