const script_host = location.origin;
const script_ws = script_host.replace('http', 'ws');

const app_dek = "dekubitus";

let ws;
try {
    ws = new WebSocket(`${script_ws}/apps/${app_dek}`, ["soap", "wamp"]);
} catch (error) {
    console.error('WebSocket-Fehler:', error);
}

// Initialisierung des Canvas
const canvas = document.getElementById('gameCanvas');
const ctx = canvas.getContext('2d');

// Spieler-Position und Eigenschaften
let playerX = canvas.width / 2;
const playerY = canvas.height - 50;
const playerWidth = 100;
const playerHeight = 20;

// Ball-Eigenschaften
let ballX = canvas.width / 2;
let ballY = canvas.height / 2;
const ballRadius = 10;
let ballSpeedX = 3;
let ballSpeedY = -3;

// Score
let score = 0;

if (ws) {
    ws.onopen = () => {
        console.log('WebSocket verbunden');
    };

    ws.onmessage = (event) => {
        const data = JSON.parse(event.data);
    
        if (data.wsevent === 'normdata' && data.imagetype === 'dkb_live') {
            const values = data.values;
            const nCols = data.n_cols;
    
            // Anzahl der Zeilen berechnen
            const nRows = Math.floor(values.length / nCols);
    
            // Druck auf der linken und rechten Seite berechnen
            let leftPressure = 0;
            let rightPressure = 0;
    
            for (let row = 0; row < nRows; row++) {
                for (let col = 0; col < nCols; col++) {
                    const index = row * nCols + col;
                    if (col < nCols / 2) {
                        leftPressure += values[index]; // Linke Hälfte
                    } else {
                        rightPressure += values[index]; // Rechte Hälfte
                    }
                }
            }
    
            // Bewegung basierend auf der Druckverteilung
            const threshold = 10; // Empfindlichkeit, ab wann Bewegung ausgelöst wird
            if (leftPressure > rightPressure + threshold) {
                playerX -= 15; // Bewegung nach links
            } else if (rightPressure > leftPressure + threshold) {
                playerX += 15; // Bewegung nach rechts
            }
    
            // Begrenzung des Spielers im Canvas
            playerX = Math.max(0, Math.min(playerX, canvas.width - playerWidth));
        }
    };
    
    ws.onerror = (error) => {
        console.error('WebSocket-Fehler:', error);
    };

    ws.onclose = () => {
        console.log('WebSocket geschlossen');
    };
}

// Ball-Bewegung und Kollisionslogik
function updateBall() {
    ballX += ballSpeedX;
    ballY += ballSpeedY;

    // Kollision mit den Wänden
    if (ballX - ballRadius < 0 || ballX + ballRadius > canvas.width) {
        ballSpeedX = -ballSpeedX; // Richtung umkehren
    }

    if (ballY - ballRadius < 0) {
        ballSpeedY = -ballSpeedY; // Richtung umkehren
    }

    // Kollision mit dem Spieler
    if (
        ballY + ballRadius > playerY &&
        ballX > playerX &&
        ballX < playerX + playerWidth
    ) {
        ballSpeedY = -ballSpeedY; // Richtung umkehren
        score++; // Score erhöhen
    }

    // Ball fällt runter
    if (ballY - ballRadius > canvas.height) {
        alert(`Game Over! Dein Score: ${score}`);
        resetGame();
    }
}

// Spiel zurücksetzen
function resetGame() {
    ballX = canvas.width / 2;
    ballY = canvas.height / 2;
    ballSpeedX = 3;
    ballSpeedY = -3;
    score = 0;
}

// Spiellogik
function draw() {
    // Canvas löschen
    ctx.clearRect(0, 0, canvas.width, canvas.height);

    // Spieler zeichnen
    ctx.fillStyle = 'blue';
    ctx.fillRect(playerX, playerY, playerWidth, playerHeight);

    // Ball zeichnen
    ctx.beginPath();
    ctx.arc(ballX, ballY, ballRadius, 0, Math.PI * 2);
    ctx.fillStyle = 'red';
    ctx.fill();
    ctx.closePath();

    // Score anzeigen
    ctx.fillStyle = 'black';
    ctx.font = '20px Arial';
    ctx.fillText(`Score: ${score}`, 10, 20);

    // Ball-Bewegung aktualisieren
    updateBall();

    // Nächsten Frame anfordern
    requestAnimationFrame(draw);
}

draw();
