#! /bin/bash
#
# vlbdisplay.sh
#

### BEGIN INIT INFO
# Provides:          vlbdisplay
# Required-Start:    vmkstationd.sh
# Required-Stop:     
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# X-Interactive:     true
# Short-Description: Velobox Displaymanager
# Description:       Start des Displaymanagers
#  Dieses Skript startet den Displaymanager einer Velobox.
### END INIT INFO

# Das Skript nach /etc/init.d kopieren und mit
#$ update-rc.d vlbdisplay.sh defaults
# scharf schalten.


VLBDISPLAY=/usr/local/vmkstationd/bin/sitzknochenabstand.tk
LOGDIR=/var/local/log

# PID des laufenden Prozesses oder leer.
PID=`pgrep -f "wish $VLBDISPLAY"`

case "$1" in
    start)
        if [ -n "$PID" ]; then
            echo "vlbdisplay laeuft bereits. PID=${PID}."
            exit
        fi
        USAGE=`sed -n '/^USAGE=/s/USAGE=//p' /usr/local/etc/velobox.conf 2>/dev/null`
        if [ "$USAGE" != "smartcube" ]; then
            echo "\$USAGE is '${USAGE:-undefined}' => won't start vlbdisplay"
            # Das ist kein Fehler.
            exit 0
        fi
#        # Framebuffer device anpassen
#        FBDEV=fb0   # rpi3
#        [ -c /dev/fb1 ] && FBDEV=fb1    # rpi4
#        cp /usr/share/X11/xorg.conf.d/99-fbturbo.conf /tmp
#        sed "s/fb[01]/${FBDEV}/" /tmp/99-fbturbo.conf > /usr/share/X11/xorg.conf.d/99-fbturbo.conf
#        [ $? -ne 0 ] && exit 1
        # Ausschaltzeit screen-saver 0 => nie ausschalten
        # Power save Management aus
        startx $VLBDISPLAY -- -s 0 -dpms &
        ;;
    status)
        if [ -n "$PID" ]; then
            echo "vlbdisplay laeuft. PID=${PID}."
            exit 0
        else
            echo "vlbdisplay laeuft nicht."
            exit 3
        fi
        ;;
    stop)
        if [ -z "$PID" ]; then
            echo "vlbdisplay laeuft nicht."
        fi
        PIDX=`pgrep -f startx`
        kill $PID
        if [ $? -eq 0 ]; then
            while [ -d /proc/$PIDX ]; do
                sleep 1
            done
            echo "vlbdisplay beendet."
        else
            echo "vlbdisplay konnte nicht beendet werden."
        fi
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "Usage: $0 {start|status|stop|restart}"
        exit 1
        ;;
esac

