const canvas = document.getElementById('heatmapCanvas');
const ctx = canvas.getContext('2d');

//[{"recording_id":"198","session_id":"57","analysis":"2","finished":"2024-07-22 13:01:24","product":"","product_label":"","n_pressure_rows":"28","n_pressure_cols":"16","pressure_values":"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 87 120 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 84 0 0 0 0 0 0 0 0 0 30 0 0 0 0 463 837 0 0 0 0 0 0 0 0 31 427 33 0 0 436 4486 5038 790 0 0 0 0 0 0 113 371 781 265 0 0 760 3140 4035 316 0 0 0 0 0 105 313 716 905 344 0 481 1595 1653 548 0 0 0 0 0 0 0 566 541 566 53 0 0 752 328 0 0 0 0 0 0 0 219 1190 615 175 0 0 0 0 0 0 0 0 0 0 0 0 347 1408 663 0 0 0 0 0 0 0 0 0 0 0 0 0 47 1212 186 0 0 0 0 0 0 0 0 0 0 0 0 0 118 477 288 0 0 0 0 0 0 0 0 0 0 0 0 0 0 93 0 147 229 0 0 0 0 0 0 0 0 0 0 0 0 0 103 442 385 154 0 0 0 0 0 0 0 0 0 0 0 0 85 87 156 0 0 0 0 0 0 0 0 0 0 0 0 31 86 53 0 0 0 0 0 0 0 0 0 0 0 0 0 0 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0","max_pressure":"5038","mask":"1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 0 0 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1","results":"{\"pelvisrotation\": {\"width\": 118.8,  \"height\": 96.4,  \"center\": {\"x\": 8.9, \"y\": 11.2},  \"front\": {\"x\": 8.2, \"y\": 13.4},  \"right\": {\"x\": 14.4, \"y\": 8.4},  \"rear\": {\"x\": 9.6, \"y\": 9.1},  \"left\": {\"x\": 3.9, \"y\": 13.7},  \"c1\": {\"x\": 3.2, \"y\": 16.0},  \"c2\": {\"x\": 13.7, \"y\": 10.7},  \"c3\": {\"x\": 15.1, \"y\": 6.3},  \"c4\": {\"x\": 4.6, \"y\": 11.6} },  \"veloscore\": 0.9,  \"front_rear\": \"22:78\",  \"left_right\": \"17:83\",  \"center\": {\"x\": 10.0, \"y\": 11.1},  \"center_left\": {\"x\": 5.7, \"y\": 13.2},  \"center_right\": {\"x\": 12.1, \"y\": 10.0}}","notes":""}]
//Reynard Boyd 44 [{"recording_id":"157","session_id":"44","analysis":"2","finished":"2024-06-26 16:00:43","product":"(Brand)","product_label":"(Type)","n_pressure_rows":"28","n_pressure_cols":"16","pressure_values":"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1801 71 0 0 516 907 809 565 923 952 740 561 0 0 0 0 2081 1595 919 1727 2818 3512 3834 2858 2937 3985 3823 3037 2263 977 527 241 2501 1428 2959 3918 4825 5692 4587 2760 2900 4577 5689 5719 4451 3013 1337 761 1118 2922 4571 5745 5610 4967 4111 1838 1586 3503 4570 5041 5165 4049 2599 1292 1992 3955 4837 4706 4073 3687 2928 1392 1343 2756 3741 4367 5243 5263 3963 2442 2405 5199 5726 4488 3740 3304 2596 1361 1199 2298 3070 3537 4061 4799 4593 3095 4081 5294 4308 3640 3211 2883 2274 1301 1197 2117 2842 3334 3896 5001 5379 4427 3515 5029 4484 3707 3193 2776 2196 1414 1280 1967 2551 2791 3085 3796 4720 4338 3943 3686 3164 2812 2558 2298 1916 1448 1390 1893 2347 2600 2943 3723 4581 4349 2155 3196 2996 2666 2353 2094 1836 1608 1535 1785 1975 2096 2271 2678 3215 3587 1841 2133 2136 1981 1848 1682 1614 1763 1680 1718 1775 1846 2018 2274 2502 2323 770 1490 1695 1684 1578 1466 1630 1924 1856 1556 1440 1408 1464 1548 1441 1400 519 903 1090 1201 1177 1125 1382 2014 1838 1404 1179 1132 1109 1043 852 577 202 521 742 894 934 917 1264 1899 1963 1185 934 844 765 663 501 312 0 55 327 516 597 617 927 1822 1850 1107 666 553 442 246 0 0 0 0 0 100 294 410 752 1584 1824 932 435 176 0 0 0 0 0 0 0 0 0 0 454 1303 1438 650 45 0 0 0 0 0 0 0 0 0 0 0 163 909 979 356 0 0 0 0 0 0 0 0 0 0 0 0 0 604 527 0 0 0 0 0 0 0 0 0 0 0 0 0 0 334 172 0 0 0 0 0 0 0 0 0 0 0 0 0 0 124 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 73 0 0 0 0 0 0 0 0","max_pressure":"5745","mask":"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0","results":"{\"pelvisrotation\": {\"width\": 7.4,  \"height\": 6.9,  \"center\": {\"x\": 7.5, \"y\": 10.2},  \"front\": {\"x\": 7.4, \"y\": 10.4},  \"right\": {\"x\": 7.8, \"y\": 10.0},  \"rear\": {\"x\": 7.5, \"y\": 10.0},  \"left\": {\"x\": 7.1, \"y\": 10.4},  \"c1\": {\"x\": 7.1, \"y\": 10.5},  \"c2\": {\"x\": 7.8, \"y\": 10.2},  \"c3\": {\"x\": 7.9, \"y\": 9.9},  \"c4\": {\"x\": 7.2, \"y\": 10.2} },  \"veloscore\": 9.8,  \"front_rear\": \"26:74\",  \"left_right\": \"51:49\",  \"center\": {\"x\": 7.5, \"y\": 10.2},  \"center_left\": {\"x\": 3.5, \"y\": 10.2},  \"center_right\": {\"x\": 11.5, \"y\": 10.3}}","notes":" "},{"recording_id":"158","session_id":"44","analysis":"2","finished":"2024-06-26 16:00:51","product":"(Brand)","product_label":"(Type)","n_pressure_rows":"28","n_pressure_cols":"16","pressure_values":"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 75 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1903 102 0 0 495 910 803 530 834 936 740 545 0 0 0 0 2173 1633 900 1686 2765 3450 3748 2685 2769 3839 3786 3041 2281 998 537 263 2549 1418 2934 3877 4763 5618 4487 2626 2699 4446 5621 5701 4495 3062 1355 796 1103 2911 4550 5724 5590 4918 4051 1767 1498 3395 4485 4988 5178 4066 2651 1336 1981 3919 4835 4727 4100 3693 2918 1367 1300 2700 3690 4334 5211 5293 3991 2518 2347 5170 5720 4525 3801 3336 2611 1377 1168 2276 3055 3512 4019 4761 4605 3163 3991 5220 4285 3656 3252 2914 2296 1308 1180 2105 2834 3318 3849 4936 5347 4490 3410 4975 4466 3709 3233 2825 2225 1422 1267 1964 2545 2772 3041 3723 4667 4494 3957 3643 3140 2793 2565 2336 1952 1467 1397 1897 2354 2586 2911 3665 4624 4484 2185 3221 2963 2652 2356 2113 1861 1619 1527 1790 1973 2081 2240 2628 3188 3747 1885 2120 2118 1973 1844 1703 1642 1804 1707 1738 1783 1834 2000 2263 2530 2392 756 1480 1680 1667 1566 1471 1644 1954 1895 1578 1448 1401 1442 1522 1466 1462 549 911 1090 1188 1158 1116 1395 2053 1882 1432 1186 1138 1112 1040 884 642 220 545 750 890 920 906 1267 1935 2007 1227 946 850 775 681 526 342 0 104 371 524 596 609 936 1855 1897 1132 681 567 456 312 9 0 0 0 0 104 312 411 758 1620 1863 970 471 210 0 0 0 0 0 0 0 0 0 0 471 1328 1498 687 47 0 0 0 0 0 0 0 0 0 0 0 196 952 1034 392 0 0 0 0 0 0 0 0 0 0 0 0 0 638 578 0 0 0 0 0 0 0 0 0 0 0 0 0 0 379 249 0 0 0 0 0 0 0 0 0 0 0 0 0 0 88 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 37 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 37 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 66 18 0 0 0 0 0 0 0","max_pressure":"5724","mask":"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0","results":"{\"pelvisrotation\": {\"width\": 6.3,  \"height\": 6.0,  \"center\": {\"x\": 7.5, \"y\": 10.2},  \"front\": {\"x\": 7.5, \"y\": 10.4},  \"right\": {\"x\": 7.8, \"y\": 10.1},  \"rear\": {\"x\": 7.5, \"y\": 10.1},  \"left\": {\"x\": 7.1, \"y\": 10.4},  \"c1\": {\"x\": 7.1, \"y\": 10.5},  \"c2\": {\"x\": 7.7, \"y\": 10.2},  \"c3\": {\"x\": 7.8, \"y\": 10.0},  \"c4\": {\"x\": 7.1, \"y\": 10.3} },  \"veloscore\": 10.1,  \"front_rear\": \"27:73\",  \"left_right\": \"51:49\",  \"center\": {\"x\": 7.5, \"y\": 10.3},  \"center_left\": {\"x\": 3.5, \"y\": 10.2},  \"center_right\": {\"x\": 11.5, \"y\": 10.3}}","notes":" "}]

 
//const stringMatrix= "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 816 1171 413 0 0 0 1168 1534 0 0 0 0 0 0 0 1332 1806 1613 729 0 0 228 1371 2063 1954 0 0 0 0 0 1632 2479 2812 2006 952 427 144 574 1475 2649 3056 2945 0 0 0 2245 3017 3317 2974 2063 1061 663 515 798 1757 2667 3828 3953 2670 0 0 4223 4617 4056 3184 2030 1283 825 721 882 1539 2321 3373 3815 2684 0 0 3734 4068 3219 2644 1989 1215 970 880 1042 1654 2353 3328 3811 2766 0 0 4971 4260 3616 2844 2091 1433 1179 1139 1275 1779 2448 3326 3634 3812 0 0 3238 3821 3152 2680 2104 1547 1486 1466 1579 2079 2799 3609 5000 4527 0 0 0 3539 3239 2689 2172 1777 1701 1643 1774 1954 2296 2834 2980 0 0 0 0 2801 2635 2264 1949 1848 1947 1825 1941 2136 2391 2536 2446 0 0 0 0 0 2729 2328 1993 2010 1997 1828 1925 1871 2052 2030 0 0 0 0 0 0 2089 2113 1834 2050 2213 2056 2199 2093 2027 1686 0 0 0 0 0 0 1635 1828 1891 2239 2404 2460 2487 1966 1649 1162 0 0 0 0 0 0 0 1315 1592 2290 2728 2941 2726 1932 1277 0 0 0 0 0 0 0 0 855 1323 2206 2740 2941 2647 1435 800 0 0 0 0 0 0 0 0 543 1084 1986 2548 2870 2348 1225 500 0 0 0 0 0 0 0 0 0 0 1863 2348 2593 2138 0 0 0 0 0 0 0 0 0 0 0 0 1645 2138 2313 1834 0 0 0 0 0 0 0 0 0 0 0 0 1338 1759 1845 1483 0 0 0 0 0 0 0 0 0 0 0 0 993 1286 1353 1005 0 0 0 0 0 0 0 0 0 0 0 0 667 939 915 657 0 0 0 0 0 0 0 0 0 0 0 0 527 721 747 482 0 0 0 0 0 0 0 0 0 0 0 0 0 921 902 0 0 0 0 0 0 0";
//const stringMatrix= "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 87 120 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 84 0 0 0 0 0 0 0 0 0 30 0 0 0 0 463 837 0 0 0 0 0 0 0 0 31 427 33 0 0 436 4486 5038 790 0 0 0 0 0 0 113 371 781 265 0 0 760 3140 4035 316 0 0 0 0 0 105 313 716 905 344 0 481 1595 1653 548 0 0 0 0 0 0 0 566 541 566 53 0 0 752 328 0 0 0 0 0 0 0 219 1190 615 175 0 0 0 0 0 0 0 0 0 0 0 0 347 1408 663 0 0 0 0 0 0 0 0 0 0 0 0 0 47 1212 186 0 0 0 0 0 0 0 0 0 0 0 0 0 118 477 288 0 0 0 0 0 0 0 0 0 0 0 0 0 0 93 0 147 229 0 0 0 0 0 0 0 0 0 0 0 0 0 103 442 385 154 0 0 0 0 0 0 0 0 0 0 0 0 85 87 156 0 0 0 0 0 0 0 0 0 0 0 0 31 86 53 0 0 0 0 0 0 0 0 0 0 0 0 0 0 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
let stringMatrix ="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1801 71 0 0 516 907 809 565 923 952 740 561 0 0 0 0 2081 1595 919 1727 2818 3512 3834 2858 2937 3985 3823 3037 2263 977 527 241 2501 1428 2959 3918 4825 5692 4587 2760 2900 4577 5689 5719 4451 3013 1337 761 1118 2922 4571 5745 5610 4967 4111 1838 1586 3503 4570 5041 5165 4049 2599 1292 1992 3955 4837 4706 4073 3687 2928 1392 1343 2756 3741 4367 5243 5263 3963 2442 2405 5199 5726 4488 3740 3304 2596 1361 1199 2298 3070 3537 4061 4799 4593 3095 4081 5294 4308 3640 3211 2883 2274 1301 1197 2117 2842 3334 3896 5001 5379 4427 3515 5029 4484 3707 3193 2776 2196 1414 1280 1967 2551 2791 3085 3796 4720 4338 3943 3686 3164 2812 2558 2298 1916 1448 1390 1893 2347 2600 2943 3723 4581 4349 2155 3196 2996 2666 2353 2094 1836 1608 1535 1785 1975 2096 2271 2678 3215 3587 1841 2133 2136 1981 1848 1682 1614 1763 1680 1718 1775 1846 2018 2274 2502 2323 770 1490 1695 1684 1578 1466 1630 1924 1856 1556 1440 1408 1464 1548 1441 1400 519 903 1090 1201 1177 1125 1382 2014 1838 1404 1179 1132 1109 1043 852 577 202 521 742 894 934 917 1264 1899 1963 1185 934 844 765 663 501 312 0 55 327 516 597 617 927 1822 1850 1107 666 553 442 246 0 0 0 0 0 100 294 410 752 1584 1824 932 435 176 0 0 0 0 0 0 0 0 0 0 454 1303 1438 650 45 0 0 0 0 0 0 0 0 0 0 0 163 909 979 356 0 0 0 0 0 0 0 0 0 0 0 0 0 604 527 0 0 0 0 0 0 0 0 0 0 0 0 0 0 334 172 0 0 0 0 0 0 0 0 0 0 0 0 0 0 124 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 73 0 0 0 0 0 0 0 0"

//stringMatrix = `0 0 0 100 0 0 0 0 0 0 0 0 100 0 0 0`

const max_pressure=6500


function convertToMatrix(data, columns) {
  const values = data.split(' ').map(Number);
  //const values2 = values.reverse()
  const rows = values.length / columns;
  const matrix = [];

  for (let i = 0; i < rows; i++) {
    //console.log(values.slice(i * columns, (i + 1) * columns));
    //let xxx = values.slice(i * columns, (i + 1) * columns)
    //matrix.push(xxx.reverse());
    matrix.push(values.slice(i * columns, (i + 1) * columns));
  }

  return matrix.reverse();
  //return matrix;
}

const old_matrix = convertToMatrix(stringMatrix, 16);
//console.log(matrix);

function replaceZeros(matrix) {
  for (let i = 0; i < matrix.length; i++) {
    for (let j = 0; j < matrix[i].length; j++) {
      if (matrix[i][j] === 0) {
        matrix[i][j] = -1;
      }
    }
  }
  return matrix;
}

let matrix = replaceZeros(old_matrix);
console.log(matrix);


const cellSize = 20; // Pixel pro Zelle auf dem Canvas, 1 cm entspricht 20 Pixeln für eine bessere Darstellung

function getColor(value) {
  const maxPressure = max_pressure; // Maximaler Druckwert
  const range = value / maxPressure; // Normalisiere den Wert auf den Bereich 0-1

  let r = 0, g = 0, b = 0;
  if (range < 0.25) {
    // Blau zu Grün
    g = 255 * (range / 0.25); // Grüner Anteil nimmt zu
    b = 255; // Blauer Anteil ist maximal
  } else if (range < 0.5) {
    // Grün
    g = 255;
    b = 255 - 255 * ((range - 0.25) / 0.25); // Blauer Anteil nimmt ab
  } else if (range < 0.75) {
    // Grün zu Gelb
    r = 255 * ((range - 0.5) / 0.25); // Roter Anteil nimmt zu
    g = 255;
  } else {
    // Gelb zu Rot
    r = 255;
    g = 255 - 255 * ((range - 0.75) / 0.25); // Grüner Anteil nimmt ab
  }

  return `rgb(${Math.floor(r)}, ${Math.floor(g)}, ${Math.floor(b)})`;
}

function calculateCentroid(matrix, side) {
  let totalWeight = 0;
  let weightedSumX = 0;
  let weightedSumY = 0;
  const columns = matrix[0].length;
  const startCol = side === 'left' ? 0 : Math.floor(columns / 2);
  const endCol = side === 'left' ? Math.floor(columns / 2) : columns;
  console.log(side, startCol, endCol);
  for (let y = 0; y < matrix.length; y++) {
    for (let x = startCol; x < endCol; x++) {
      const value = matrix[y][x];
      if (value !== -1) {
        weightedSumX += x * value;
        weightedSumY += y * value;
        totalWeight += value;
      }
    }
  }

  if (totalWeight === 0) return null;

  const centroidX = weightedSumX / totalWeight;
  const centroidY = weightedSumY / totalWeight;
  console.log(side,`x:${centroidX}`,`y:${centroidY}`);
  if(side== 'right')
  return { x: centroidX+0.5, y: centroidY+0.5 };
  if(side=='left')
  return { x: centroidX+0.5, y: centroidY+0.5 };

}

function calculateCOP(matrix) {
  let totalWeight = 0;
  let weightedSumX = 0;
  let weightedSumY = 0;

/* The above code is iterating over a 2D array called `matrix` and calculating the weighted sum of x
and y coordinates based on the values in the matrix. It skips any elements with a value of -1. The
code calculates the weighted sum of x and y coordinates by multiplying the x and y values with the
corresponding element value in the matrix and then adds these values to `weightedSumX` and
`weightedSumY` respectively. It also keeps track of the total weight by adding up all the
non-skipped element values. The code includes console.log statements to print out the x value */
  for (let y = 0; y < matrix.length; y++) {
    for (let x = 0; x < matrix[y].length; x++) {
      const value = matrix[y][x];
      if (value !== -1) {
        weightedSumX += x * value;
        weightedSumY += y * value;
        totalWeight += value;
        console.log('cop x',x, value, x*value);
        console.log('cop y',y, value, y*value);
        console.log('total',totalWeight)
      }
    }
  }

  if (totalWeight === 0) return null;

  console.log(weightedSumX,totalWeight,weightedSumX / totalWeight);
  console.log(weightedSumY,totalWeight,weightedSumY / totalWeight);

  const centroidX = weightedSumX / totalWeight;
  const centroidY = weightedSumY / totalWeight;
  console.log("COP",`x:${centroidX}`,`y:${centroidY}`);
  return { x: centroidX+0.5, y: centroidY+0.5 };
}

function drawHeatmapAndCentroids() {
  // Zeichne Heatmap
  for (let y = 0; y < matrix.length; y++) {
    for (let x = 0; x < matrix[y].length; x++) {
      const value = matrix[y][x];
      if (value !== -1) {
        ctx.fillStyle = getColor(value);
        ctx.fillRect(x * cellSize, y * cellSize, cellSize, cellSize);
      }
    }
  }

   // Zeichne Mittellinien
   drawMiddleLines();

  // Berechne und zeichne Schwerpunkte und COP
  const leftCentroid = calculateCentroid(matrix, 'left');
  const rightCentroid = calculateCentroid(matrix, 'right');
  const cop = calculateCOP(matrix);

  function drawCentroid(centroid, color) {
    if (centroid) {
      ctx.beginPath();
      ctx.arc(centroid.x * cellSize, centroid.y * cellSize, 5, 0, 2 * Math.PI);
      ctx.fillStyle = color;
      ctx.fill();
    }
  }

  drawCentroid(leftCentroid, 'blue');
  drawCentroid(rightCentroid, 'green');
  drawCentroid(cop, 'yellow');

  // Berechne Distanz und Winkel, wenn beide Schwerpunkte vorhanden sind
  if (leftCentroid && rightCentroid) {
    const dx = rightCentroid.x+0.5 - leftCentroid.x+0.5;
    const dy = rightCentroid.y+0.5 - leftCentroid.y+0.5;
    const distance = Math.sqrt(dx * dx + dy * dy) * 1; // Umrechnung in Zentimeter
    const angle = Math.atan2(dy, dx) * (180 / Math.PI);

    // Zeichne Linie zwischen den Schwerpunkten
    ctx.beginPath();
    ctx.moveTo(leftCentroid.x * cellSize, leftCentroid.y * cellSize);
    ctx.lineTo(rightCentroid.x * cellSize, rightCentroid.y * cellSize);
    ctx.strokeStyle = 'purple';
    ctx.lineWidth = 2;
    ctx.stroke();

    // Anzeige von Distanz und Winkel
    ctx.fillStyle = 'black';
    ctx.font = '16px Arial';
    ctx.fillText(`Distanz: ${distance.toFixed(2)} cm`, 20, 20);
    ctx.fillText(`Winkel: ${angle.toFixed(2)}°`, 20, 40);
  }

  function drawMiddleLines() {
    // Vertikale Mittellinie
    const verticalLineX = matrix[0].length * cellSize / 2;
    ctx.beginPath();
    ctx.moveTo(verticalLineX, 0);
    ctx.lineTo(verticalLineX, matrix.length * cellSize);
    ctx.strokeStyle = '#000';  // Schwarze Linie
    ctx.lineWidth = 1;
    ctx.stroke();
  
    // Horizontale Mittellinie
    const horizontalLineY = matrix.length * cellSize / 2;
    ctx.beginPath();
    ctx.moveTo(0, horizontalLineY);
    ctx.lineTo(matrix[0].length * cellSize, horizontalLineY);
    ctx.strokeStyle = '#000';  // Schwarze Linie
    ctx.lineWidth = 1;
    ctx.stroke();
  }
}

drawHeatmapAndCentroids();