# HTTP-Domäne /storedbld
#
# Schickt die zuvor (typischerweise von einer App) unter
#   ::WSServer::httpdomains::storedbld::hockerbild
# hinterlegten Druckwerte eines Hockerbildes zum Speichern an den Webservice.
# Die zugehörige Emailadresse wird mit dem Schlüssel "email" als GET-Parameter angegeben.
# Zurückgegeben wird die Antwort des Webservice.
#
# Historie:
# 20.06.2019 Siegmar Müller Begonnen
# 25.06.2019 Siegmar Müller Fertig
# 20.06.2023 Siegmar Müller Kommentiert

package require http

namespace eval storedbld {

    # Übergabevariable für die zu speichernden Druckwerte
    variable hockerbild [list]

    # Requestbearbeitung
    # @param clientsocket   Schlüssel für den Clientkontext
    # @param query          GET-Parameter
    # @return               Antwort des Webservice oder Fehlertext
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context
        variable hockerbild

	    set context(contenttype) "text/plain"
        if {[llength $hockerbild] > 0} {
            # Hochladen
            set email ""
            set dict_query [dict create {*}$query]
            if {[dict exists $dict_query email]} {
                set email [dict get $dict_query email]
            }
            set data "dbld $::STATION_NR\n"
            append data "hdr [vmkcrypt encrypt "$email\n16,28\n2"]\n"
            # Druckwerte verschlüsselt hinzufügen
            append data "data [vmkcrypt encrypt [join $hockerbild " "]]\n"
            srvLog {} Debug $data
            set hockerbild [list]; # Nicht noch einmal hochladen.
            # -query impliziert POST
            set tokenHttp [::http::geturl "${::WS_URL}/dbld" -type "text/plain" -query $data]
            ::http::wait $tokenHttp
            if {[string equal [::http::status $tokenHttp] ok]} {
                set antwort [::http::data $tokenHttp]
                # Die Antwort kann eine Fehlermeldung sein: "^[1-9][0-9]* Meldung"
                if {[regexp {^[1-9][0-9]* } $antwort]} {; # Fehlermeldung
                    set antwort [regsub {^[1-9][0-9]*} $antwort {Error:}]
                } else {; # Email, erst entschlüsseln
                    # Die Emailadresse kommt in eckigen Klammern.
                    set encrypted [regsub {^.*\[(.*)\].*$} $antwort {\1}]
                    # Daraus wird jetzt ein JSON-Objekt gebaut.
                    #TODO decrypt mit fehlerhaften Daten liefert eine Exception => catch
                    set antwort "{\"email\": \"[vmkcrypt decrypt $encrypted]\"}"
                }
            } else {; # HTTP-Fehler
                set antwort "Error: [::http::code]"
            }
            ::http::cleanup $tokenHttp
            return $antwort
        } else {
            return "Error: No image to store."
        }
    }; # proc handleClientRequest 

}; # namespace eval storedbld 
