#! /bin/bash
#
# vmkstationd.sh
#

### BEGIN INIT INFO
# Provides:          vmkstationd
# Required-Start:    $local_fs $remote_fs $network $syslog $named
# Required-Stop:     $local_fs $remote_fs $network $syslog $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# X-Interactive:     true
# Short-Description: Velometrik Arbeitsstation
# Description:       Start des Stationsservers
#  Dieses Skript startet den Server einer Velometrik-Arbeitsstation.
### END INIT INFO

# Das Skript nach /etc/init.d kopieren und mit
#$ update-rc.d vmkstationd.sh defaults
# scharf schalten.


VMKSTATIOND=/usr/local/vmkstationd/vmkstationd.tcl
LOGDIR=/var/local/log


# PID des laufenden Prozesses oder leer.
PID=`pgrep -f "/usr/bin/tclsh $VMKSTATIOND"`

case "$1" in
    start)
        if [ -n "$PID" ]; then
            echo "vmkstationd laeuft bereits. PID=${PID}."
            exit
        fi
        if [ ! -d $LOGDIR ]; then
            mkdir -p $LOGDIR
        fi
        if [ -d /usr/local/vmkstationd_next ]; then # Eine neue Version wurde bereitgestellt.
            # => Links anpassen
            rm -f /usr/local/vmkstationd_last # Das wird mit einer neuen Version obsolet.
            if [ -d /usr/local/vmkstationd ]; then # Eine aktuelle Version existiert.
                # Die wird zur vorhergehenden.
                mv /usr/local/vmkstationd /usr/local/vmkstationd_last
            fi
            # Die neue Version starten.
            mv /usr/local/vmkstationd_next /usr/local/vmkstationd
        elif [ -d /usr/local/vmkstationd_last ]; then # Start mit neuer Version fehlgeschlagen
            # => Zur Vorversion zurückgehen
            rm -f /usr/local/vmkstationd
            mv /usr/local/vmkstationd_last /usr/local/vmkstationd
        fi
        # Die (nunmehr) aktuelle Version starten.
        cd $LOGDIR
        $VMKSTATIOND -L ${LOGDIR}/vmkstationd.log &
        # Nach erfolgreichem Start löscht $VMKSTATIOND /usr/local/vmkstationd_last.
        ;;
    status)
        if [ -n "$PID" ]; then
            echo "vmkstationd laeuft. PID=${PID}."
            exit 0
        else
            echo "vmkstationd laeuft nicht."
            exit 3
        fi
        ;;
    stop)
        if [ -z "$PID" ]; then
            echo "vmkstationd laeuft nicht."
        else
            # Es müssen auch die Childprozesse gekillt werden.
            CHILDPIDS=`pgrep -P $PID`
            for CHILDPID in $CHILDPIDS; do
                kill $CHILDPID 
                wait $CHILDPID 
                echo "vmkstationd child process $CHILDPID beendet."
            done
            kill $PID
            if [ $? -eq 0 ]; then
                echo "vmkstationd beendet."
            else
                echo "vmkstationd konnte nicht beendet werden."
            fi
        fi
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "Usage: $0 {start|status|stop|restart}"
        exit 1
        ;;
esac

