/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
    Created on : 12.06.2021, 15:08:29
    Author     : Peter Bauer
*/


//TODO aufräumen Funktionen prüfen und wenn entfernen bei nicht nutzung

const host = location.origin;
const ws = host.replace('http','ws');
const apps= "satteldruckanalyse";
UIkit.modal('#modal_load_side').show();
const baseURL ="https://www.the-perfect-fit-system.com/"

SystemCards()

const restoreForm = document.forms.namedItem("restore2");
restoreForm.addEventListener(
    "submit",
    (event) => {
        const formData = new FormData(restoreForm);
        const request = new XMLHttpRequest();
        request.open("POST", "/db_buprest", true);
        request.onload = () => {
            if (request.status === 200) {
                OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})
            } else {
                OpenModDialog({type:'error',title:["db_upload_err"],msg:`${request.responseText}`,master_btn:['button_ok']})
            }
        };
        request.send(formData);
        event.preventDefault();
    },
    false
);

const api = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var onsqlresult = getLog();
var setting = new Object();

api.onmessage = (msg) => {
    let data = new Object();
    try {
        data = JSON.parse(msg.data)   
    } catch (error) {
        getError(error)
    }
    
    if (data.wsevent === "sqlresult"){
        try {
            onsqlresult (data.rows);           
        } catch (error) {
            getError(error)
        }
    }

}

/**
 * The function `getLog` logs the value of the `params` parameter to the console, or logs 'no SQL' if
 * `params` is falsy.
 * @param params - The `params` parameter is a variable that represents the SQL query or statement. It
 * is an optional parameter, meaning it can be omitted when calling the `getLog` function. If `params`
 * is provided, it will be logged to the console. If `params` is not provided, the
 */
function getLog(params) {
    console.log(params||'no SQL');
}


/**
 * !TODO Entfernen
 * It sends a request to the server to change the language file
 */
//function setLanguagefile() {
//    console.log('WERDE ICH GENUTZT?');
//    var systemsprache = document.getElementById("systemsprache").value;

//    var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

//    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

//    /* Sending a request to the server. */
//    httpSetconfig.open("GET", url, true);
//    httpSetconfig.send();

//    translatejs();
//}

/**
 * It sends a request to the server to set the configuration file
 */
function setConfigfile() {
    let stationsnummer = document.getElementById("stationsnummer").value;
    
    /*The "encodeURIComponent()" function is used to encode the value of the input to make it safe to be used in a URL. */
    let farbe = encodeURIComponent(document.getElementById("farbe").value);
    let empfindlichkeit = document.getElementById("empfindlichkeit").value;
    let webservice = document.getElementById("webservice").value;
    let url_smartcube = document.getElementById("url_smartcube").value;
    let login_mail = document.getElementById('system_login_mail').value;
    let login_pass = document.getElementById('system_login_pass').value;
    /* The above code is checking if the variable `url_smartcube` contains the string "http://". If it
    does, it splits the string at "http://" and takes the second part of the split (i.e. the part after
    "http://"). Then it replaces all forward slashes ("/") in that part with an empty string and assigns
    the resulting string back to `url_smartcube`. Essentially, it is removing the "http://" and any
    forward slashes from the URL. */
    if(url_smartcube.includes('http://')){
        let url = url_smartcube.split('http://')[1]
        url_smartcube = url.replaceAll('/','')
    }
    script_setting.smartcube = url_smartcube
    script_setting.LoginMail = login_mail
    script_setting.LoginPass = login_pass
    saveConfig()
    //var url = "/production/setconfigfile.tcls?stationsnummer=" + stationsnummer + "&farbe=" + farbe + "&empfindlichkeit=" + empfindlichkeit + "&webservice=" + webservice + "&url_smartcube=" + url_smartcube;
    const url = `/production/setconfigfile.tcls?stationsnummer=${stationsnummer}&farbe=${farbe}&empfindlichkeit=${empfindlichkeit}&webservice=${webservice}`;//&url_smartcube=${url_smartcube}`;

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();


    OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})

}


/**
 * The function `downloadFile` is used to download a file and display a message based on the response.
 * @returns The function does not explicitly return a value.
 */
function downloadFile() {

    if(box_status.includes('INET')||box_status.includes('LOGGED_IN')){

    const updatefile = document.getElementById("updatefile").value;
    
    /* The above code is a JavaScript function that is triggered when a file update is requested. */
    if (updatefile) {
        gears_on()
        const url = `vlbupdate.tcls?updatefile=${updatefile}`;
        const oReq = new XMLHttpRequest();

        oReq.open("GET", url, true);
        oReq.send();

     /* The above code is handling the response from an XMLHttpRequest (AJAX) request. */
        oReq.onload = (e) => {
            if(oReq.status === 500){
                setTimeout(()=>{gears_off()},1000)
            }
            const arraybuffer = oReq.response; 
            if (arraybuffer.includes("Error: 500")) {
                document.getElementById("updatemassage").value = aLangKeys[lang]["update_fail"]//"UPDATE FAILED"
                return;
            }
            document.getElementById('updatemassage').value = arraybuffer
            setTimeout(()=>{gears_off()}, 500);
            setTimeout(()=>{setReboot()},1500)
        }
        translatejs();
        return;
    }
    document.getElementById("updatefile").style.border = "1px solid red";
    document.getElementById("updatefile").style.background = "#ffd6d6";
    document.getElementById("updatefile").setAttribute("placeholder", "e.g. vlbupdate-XXX.tar.gz");
    
    } else{
        UIkit.modal('#modal-system_no_inet').show();
    }
}

/**
 * "When the user clicks on the gear icon, show the gear modal."
 * 
 * The `console.log` statement is a debugging tool. It's a way to print out a message to the browser's
 * console
 */
function gears_on() {
    console.log('show gear');
    $('#gear').modal('show');
}

/**
 * "When the user clicks the gear icon, hide the gear modal."
 * 
 * The first line of the function is a console.log statement. This is a debugging tool that will print
 * the text "hide gear" to the console
 */
function gears_off() {
    $('#gear').modal('hide');
}
/**
 * It shows a modal dialog with a message
 */
function setReboot() {

    // Request starten
    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_rebootvelobox\"><!--Reboot Velobox--></span></p>";

    translatejs();

    $("#reboot").modal('show');
}

/* The above code is checking the value of `script_setting.bg` and applying different CSS classes to
elements with the class name 'back' based on that value. If the value matches the class value of the
second child node of the element, it adds the class 'mdi-checkbox-marked-circle-outline' and removes
the class 'mdi-checkbox-blank-circle-outline'. If the value does not match, it removes the class
'mdi-checkbox-marked-circle-outline' and adds the class 'mdi-checkbox-blank-circle-outline'. */
if(script_setting.bg){
    for (let name of document.getElementsByClassName('back')) {
        if(name.childNodes[1].classList.value === script_setting.bg){
            name.classList.remove('mdi-checkbox-blank-circle-outline');
            name.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            name.classList.remove('mdi-checkbox-marked-circle-outline');
            name.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
} 

/**
 * The function `selectBack` updates the background color of an element and sends the updated settings
 * to a WebSocket server.
 * @param params - params is a parameter that represents the selected element. It is expected to be a
 * DOM element that contains child nodes.
 */
function selectBack(params) {
    script_setting.bg = params.childNodes[1].classList.value
    script_websocket.send(`set clientsettings ${JSON.stringify(script_setting)}`)

    let b = document.getElementsByClassName('right_col')[0]
    b.removeAttribute('class');
    b.classList.add(params.childNodes[1].classList.value,'right_col');

    for (let n of document.getElementsByClassName('back')) {
        if(n.childNodes[1].classList.value === script_setting.bg){
            n.classList.remove('mdi-checkbox-blank-circle-outline');
            n.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            n.classList.remove('mdi-checkbox-marked-circle-outline');
            n.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
    //setting.bgImage = params.childNodes[1].classList.value;
}

/**
 * If the parameter is 'on', set the local storage item 'DarkMode' to 0, otherwise remove the local
 * storage item 'DarkMode' and reload the page.
 * @param params - The parameter that is passed to the function.
 */
if(localStorage.getItem('DarkMode')){
    document.getElementById('system_dark').setAttribute('checked','')
}

function DarkMode() {
    if(localStorage.getItem('DarkMode')){
      localStorage.removeItem('DarkMode')
    } else {
      localStorage.setItem('DarkMode',1)
    }
    location.reload()
    }

/**
 * The function creates a list of settings with icons and labels using HTML and CSS classes.
 * @param list - The `list` parameter is an array of arrays, where each inner array contains two
 * elements: the first element is a string representing the setting name, and the second element is a
 * string representing the icon to be displayed for that setting.
 */
function Setting_List(list) {
    let append = document.getElementById('system-card-holder');
    list.forEach(element => {
        console.log(element);
        let div = newElement({element:'div'},append)
        let uk_card;
        if(element[0]=="system_adv"){
            uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card','adba','basicview'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        } else {
            let i = newElement({element:'i',cls:['readme_card','readme','mdi','mdi-help-circle-outline'],attr:[['key-title','ReadMe_title_help'],['key-readme',`Help_${element[0]}`],['onclick',`OpenReadMe('Help_${element[0]}')`]]},div)
            uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        }
        let uk_card_header = newElement({element:'div',cls:['uk-card-header','flex-column-center']},uk_card)
        let mdi = newElement({element:'div',cls:['mdi',`${element[1]}`],attr:[['style','font-size: 100px;']]},uk_card_header)
        let uk_card_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center'],attr:[['key',`${element[0]}`]]},uk_card).innerHTML = `<!--${element[0]}-->`
    }); 
    translatejs()
}
/**
 * The function opens a UIkit modal with the ID corresponding to the input SettingName.
 * @param {String}SettingName - The parameter `SettingName` is a string that represents the name of the setting
 * that needs to be accessed or modified. It is used as a reference to open the corresponding modal
 * window with the settings options.
 */
function OpenSetting(SettingName) {
    if(SettingName == 'system_costom_protocol'){
        AXIOS_Login();
    }
    UIkit.modal(`#modal-${SettingName}`).show();
}

/**
 * The function "addDate" sets the download attribute of an element with the id "startBackup" to a
 * formatted date string.
 */
function addDate() {
    const d = new Date();
    document.getElementById("startBackup").download = `VeloboxBup_${d.getFullYear() * 10000 + (d.getMonth() + 1) * 100 + d.getDate()}`;
}

/**
 * The function `SystemCards` fetches a JSON file containing system cards and passes the data to the
 * `Setting_List` function, while handling any errors with the `getError` function.
 */
function SystemCards() {
    try {
      fetch("/production/json/cards.json", {
        mode: "no-cors",
      }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (Setting_List(data.systemcards)));
    } catch (error) {
      getError(error)
    }
}


try {
    fetch("https://downloads.velometrik.de/version.json")
    .then((res)=> res.json())
    .then((data)=> update_jsn(data))
  } catch (error) {
    console.error(error);
  }
/**
 * The function `update_jsn` checks for updates in a JSON object and updates a file input element with
 * the latest version name if an update is available.
 * @param jsn - The parameter `jsn` is expected to be an object that contains information about
 * different versions of a software. It should have a property called `versionen`, which is an array of
 * objects. Each object in the `versionen` array should have properties `version` and `name`,
 * representing the
 */
  function update_jsn(jsn) {
    let comp = setInterval(()=> {
    jsn.versionen.forEach(element => {
        console.log(`%cVersion ${element.version} found \n${element.name}`,'background: #222;color:white;padding:1em');
    });
    let aV = htdocsInfo.VERSION.replaceAll('.','')
    var i = 0
    if(document.getElementById('updatefile')){
      var t = document.getElementById('updatefile')
      jsn.versionen.forEach(e => {
        let nV = e.version.replaceAll('.','')
        if (aV < nV && i==0) {
            i++;
            t.value = e.name;
            return;
        }
      });
    }
    clearInterval(comp);
    }, 500);

  }

  var user = document.getElementById('stnr').value;



/**
 * The function AXIOS_Login sends a GET request to a login endpoint with user credentials and saves the
 * response data to session storage.
 */
function AXIOS_Login() {
    axios.get(`${ baseURL }vmkservice/login`, {
            params: {
                portaluser: user,
                passwd: 'velopasswort'
            },
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden' || response.data === '13 login failed') {
                //TODO ERROR HANDLING
                OpenModDialog({type:'error',title:["error"],msg:`${response.data}`,master_btn:['button_ok']})
                return;
            }
            AXIOS_Ping();
            AXIOS_logout();
        })
        .catch(err => {
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

function AXIOS_Ping() {
    axios.get(`${ baseURL }vmkservice/ping`, {
            method: 'GET',
            withCredentials: true
        })
        .then(response => {
            if (response.data === '12 forbidden') {
                //TODO ERROR HANDLING
                OpenModDialog({type:'error',title:["error"],msg:`${response.data}`,master_btn:['button_ok']})
                
                console.log('error');
                return;
            }
            Stationsinfo = response.data;
            console.log();
            if(Stationsinfo.optionen['protokoll.beratung'] && new Date(Stationsinfo.optionen['protokoll.beratung'])>new Date()){
                console.log(`%c Custom Protokol til ${Stationsinfo.optionen['protokoll.beratung']}`,'background: #222;color: #5cbc40;padding:1em');
                script_setting.custom_protocol = new Date(Stationsinfo.optionen['protokoll.beratung'])
                saveConfig()
                getCustomProtocol(true)
            } else {
                script_setting.custom_protocol = new Date()
                saveConfig()
                getCustomProtocol(false)
            }
            translatejs();
        })
        .catch(err => {
            //TODO ERROR HANDLING
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

function AXIOS_logout() {
    axios.get(`${ baseURL }vmkservice/logout`)
        .then(response => {
        })
        .catch(err => {
            OpenModDialog({type:'error',title:["error"],msg:`${err}`,master_btn:['button_ok']})
        });
}

/**
 * The function `getCustomProtocol` updates the HTML elements based on the value of the `param`
 * parameter.
 * @param param - It looks like the `getCustomProtocol` function is designed to handle a parameter
 * called `param`. This parameter is used to determine whether certain elements on the page should be
 * hidden or modified based on its value.
 */
function getCustomProtocol(param) {
    let holder = document.getElementById('no_custom');
    holder.innerHTML = ""
    if(param == false){
        let h3 = newElement({element:'h3',attr:[['key','custom_header_false']]},holder).innerHTML = '<!---->'
        document.getElementById('custom_table').classList.add('hidden')
        document.getElementById('costom_protocol_holder').classList.add('hidden')
        document.getElementById('save_custom').classList.add('hidden')
    }
}

/* The above code is using JavaScript to create a setInterval function that runs every 1000
milliseconds (1 second). Within the setInterval function, it calls a function genCustom(), then
selects an element with the id 'CatTable' from the document. It clears the inner HTML of the
'CatTable' element. */
let inter = setInterval(()=> {
    genCustom()
    let CatTable = document.getElementById('CatTable');
    CatTable.innerHTML = ""
    cat.forEach(element => {
        let tr = newElement({element:'tr',cls:['tr_custom'],id:`cat_${element.replaceAll(' ','_')}` ,attr:[['onclick',`ShowTableCategory("${element}".replaceAll(" ","_"))`]]},CatTable)
        let td = newElement({element:'td'},tr).innerHTML = element
        let td2= newElement({element:'td'},tr)
            let btnDel = newElement({element:'button',cls:['uk-button','uk-button-default','mdi-24px','mdi', 'mdi-trash-can-outline'],attr:[['onclick',`deleteCategory('${element}')`]]},td2)
    })
    clearInterval(inter);
  }, 1000);


/**
 * The function `SetCategoryName` updates the category name in a web page and dynamically generates a
 * table row with buttons for deleting the category.
 * @param param - The `SetCategoryName` function takes a parameter `param` which is used to set the
 * category name. If the `param` is an empty string, the function will return without performing any
 * actions. Otherwise, it will set the value of an element with the id `CategoryName` to an
 * @returns The function `SetCategoryName` does not explicitly return anything.
 */
function SetCategoryName(param) {
    if(param == "")
    return;
    document.getElementById('CategoryName').value = ""

    if(!cat.includes(param)){
        cat.push(param)
    }

    let CatTable = document.getElementById('CatTable');
    CatTable.innerHTML = ""
    cat.forEach(element => {
        let tr = newElement({element:'tr',cls:['tr_custom'],id:`cat_${element.replaceAll(' ','_')}` ,attr:[['onclick',`ShowTableCategory("${element}".replaceAll(" ","_"))`]]},CatTable)
        let td = newElement({element:'td'},tr).innerHTML = element
        let td2= newElement({element:'td'},tr)
            let btnDel = newElement({element:'button',cls:['uk-button','uk-button-default','mdi-24px','mdi', 'mdi-trash-can-outline'],attr:[['onclick',`deleteCategory('${element}')`]]},td2)
    })
    customJSN[param] = []
    saveConfig()
    genCustom()
}

/**
 * The function `SetFieldName` sets a field name based on the category and name provided, updating a
 * custom protocol configuration and generating a custom output.
 * @param cat - The `cat` parameter in the `SetFieldName` function is used to specify the category or
 * group to which the field name belongs.
 * @param name - The `name` parameter in the `SetFieldName` function is the name of a field that is
 * being set in a form.
 * @returns If the `name` parameter is an empty string, the function will return without performing any
 * further actions.
 */
function SetFieldName(cat,name) {
    console.log("SETFIELDNAME",cat,name);
    if(name == "")
    return;
    document.getElementById(`field_${cat.replaceAll(' ','_')}`).value = ""
    if(!customJSN[cat]){
        customJSN[cat] = []
    }
    if(!customJSN[cat].includes(name)) {
        customJSN[cat].push(name)
    }
    script_setting.customprotocol = customJSN
    saveConfig()
    genCustom()
}

/**
 * The function `SaveCustomProtocol` saves a custom protocol setting, then saves the configuration and
 * generates a custom output.
 */
function SaveCustomProtocol() {
    script_setting.customprotocol = customJSN
    saveConfig()
    genCustom()
}

/**
 * The function `deleteCategory` deletes a key from a JSON object, hides a corresponding element in the
 * document, and logs a message indicating whether the key was successfully deleted or not.
 * @param key - The `key` parameter in the `deleteCategory` function is used to specify the key of the
 * category that you want to delete from the `customJSN` object.
 */
function deleteCategory(key) {
    if (customJSN.hasOwnProperty(key)) {
        delete customJSN[key];
        const select = document.getElementById(`cat_${key.replaceAll(' ','_')}`)
        select.classList.add('hidden')

        console.log(`%c Der Schlüssel "${key}" wurde gelöscht.`,'background: #222;color:white');
    } else {
        console.log(`%c Der Schlüssel "${key}" existiert nicht im JSON-Objekt.`,'background: #222;color:white');
    }
    script_setting.customprotocol = customJSN
    saveConfig()
    genCustom()
}

function editCategory(oldKey, newKey) {
    console.log(oldKey,newKey);
    //if (customJSN.hasOwnProperty(oldKey)) {
    //    customJSN[newKey] = customJSN[oldKey];
    //    delete customJSN[oldKey];
    //    return customJSN;
    //} else {
    //    console.log("Key not found in the customJSN.");
    //    return customJSN;
    //}
}
// Beispielaufruf:
//let editedData = editCategory('A', 'C');

/**
 * The function `deleteField` removes a specified key from an array within an object in a JavaScript
 * object, updates a setting, saves the configuration, and generates a custom output.
 * @param cat - The `cat` parameter in the `deleteField` function likely refers to the category or
 * section within the `customJSN` object where the `key` needs to be deleted. It is used to identify
 * the specific category in which the `key` exists.
 * @param key - The `key` parameter in the `deleteField` function represents the specific field or
 * property that you want to delete from the object stored in the `customJSN` variable under the
 * category specified by the `cat` parameter.
 */
function deleteField(cat,key) {
    let index = customJSN[cat].indexOf(key);
    if (index !== -1) {
    customJSN[cat].splice(index, 1);
    }
    script_setting.customprotocol = customJSN
    saveConfig()
    genCustom()
}

/**
 * The `genCustom` function dynamically generates a custom table based on data from a JSON object,
 * allowing users to add, delete, and modify fields within different categories.
 */
function genCustom() {
    let holder = document.getElementById('custom_table');
    holder.innerHTML = "";
    
    for (const category in customJSN) {
        if (Object.hasOwnProperty.call(customJSN, category)) {
            const fields = customJSN[category];
            const keys = Object.keys(customJSN);
            const index = keys.indexOf(category)
            console.log('category->fields',category,fields);
            const categoryS = category.replaceAll(' ','_').replaceAll('(','').replaceAll(')','').replaceAll('&','u').replaceAll('%','')
            let card    = newElement({element:'div',id:category.replaceAll(' ','_'),cls:['category','uk-card']},holder);
            let head    = newElement({element:'div',cls:['uk-card-header'],attr:[['style','display: flex;justify-content: space-between;align-items:center;']]},card);
            let h3      = newElement({element:'h3',cls:['uk-card-title']},head).innerHTML = category;
                let d   = newElement({element:'div'},head)
            let lab     = newElement({element:'label',attr:[['style','margin-right:1em;']]},d).innerHTML = aLangKeys[lang].cat_pos || "POS"
            let pos     = newElement({element:'input',cls:['uk-input'],attr:[['style','width: 3em'],['type','number'],['value',index+1],['onchange',`moveJSONKey('${category}',this.value)`]]},d)
            //let dele    = newElement({element:'button',cls:['uk-button','uk-button-default','mdi','mdi-18px','mdi-trash-can-outline'],attr:[['onclick',`deleteCategory('${category}')`]]},head);
            let body    = newElement({element:'div',cls:['uk-card-body']},card);
            let div_in  = newElement({element:'div',attr:[['style','display: flex;align-items: center;justify-content: space-between;']]},body)
            let inp_in  = newElement({element:'input',id:`field_${category.replaceAll(' ','_')}`,cls:['uk-input']},div_in)
            let btn_in  = newElement({element:'button',cls:['uk-button','uk-button-primary','mdi','mdi-24px','mdi-plus'],attr:[['style','padding:0 0.5em'],['onclick',`SetFieldName('${category}', document.getElementById('field_${category.replaceAll(' ','_')}').value)`]]},div_in)
            let table   = newElement({element:'table',cls:['uk-table','uk-table-divider']},body);
            fields.forEach(field => {
                let tr      = newElement({element:'tr',cls:['tr_custom']},table);
                let tdname  = newElement({element:'td'},tr).innerHTML = field;
                let tdbtn   = newElement({element:'td'},tr);
                let btntd   = newElement({element:'button',cls:['uk-button','uk-button-default','mdi','mdi-18px','mdi-trash-can-outline'],attr:[['onclick',`deleteField('${category}','${field}')`]]},tdbtn);
            });
        }
    }

    if(!localStorage.getItem('SelCat')){
        ShowTableCategory(document.getElementById('custom_categorys').value.replaceAll(' ','_'))
    } else {
        ShowTableCategory(localStorage.getItem('SelCat').replaceAll(' ','_'))
    }

}

/**
 * The function `ShowTableCategory` hides all elements with the class 'category' and shows the element
 * with the specified ID while also storing the selected category in localStorage.
 * @param param - The `param` variable in the `ShowTableCategory` function is used to specify the
 * category ID that you want to show in the table. The function hides all elements with the class name
 * 'category' and then shows the element with the specified category ID. If `param` is an empty string
 */
function ShowTableCategory(param) {
    let cat = document.getElementsByClassName('category')
    for (const i of cat) {
        console.log(i.id);
        i.classList.add('hidden')
    }
    if(param != ''){
    if(document.getElementById(param))
    document.getElementById(param).classList.remove('hidden')
    }
    localStorage.setItem('SelCat',param)
}

/**
 * The `moveJSONKey` function moves a specified key to a new position in a JSON object.
 * @param jsonObj - The `jsonObj` parameter is the JSON object that you want to modify. It should be a
 * valid JavaScript object that can be converted to JSON format.
 * @param keyToMove - The key that you want to move within the JSON object.
 * @param newPosition - The `newPosition` parameter is the new index position where you want to move
 * the specified key in the JSON object.
 * @returns a new JSON object with the specified key moved to the new position.
 */
function moveJSONKey(keyToMove, newPosition) {
    newPosition = newPosition-1
    console.log('********',keyToMove,newPosition);

    if (typeof customJSN !== 'object') {
      throw new Error('Input is not a valid JSON object');
    }
  
    if (!(keyToMove in customJSN)) {
      throw new Error('Key to move does not exist in the JSON object');
    }
  
    const keys = Object.keys(customJSN);
    const values = Object.values(customJSN);
    const indexToMove = keys.indexOf(keyToMove);
  
    if (indexToMove === -1) {
      throw new Error('Key to move not found in the keys array');
    }
  
    keys.splice(indexToMove, 1);
    values.splice(indexToMove, 1);
  
    keys.splice(newPosition, 0, keyToMove);
    values.splice(newPosition, 0, customJSN[keyToMove]);
  
    const movedJsonObj = {};
    keys.forEach((key, index) => {
      movedJsonObj[key] = values[index];
    });
    console.log('*******',movedJsonObj);
    customJSN = movedJsonObj;
    script_setting.customprotocol = customJSN
    saveConfig()
    genCustom()
  }
  
  