--
-- create_vlbclients_sqlite3.sql
-- Erstellt die lokale (Kunden-) Datenbank der Velobox für sqlite3
--

DROP TABLE IF EXISTS nextids;
DROP TABLE IF EXISTS recordings;
DROP TABLE IF EXISTS sessions;
DROP TABLE IF EXISTS clients;
DROP TABLE IF EXISTS masks;


CREATE TABLE nextids (
    table_name VARCHAR PRIMARY KEY,
    next_id INT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_nextids_pkey ON nextids(table_name);

CREATE TABLE clients (
    client_id INTEGER CONSTRAINT idx_clients_pkey PRIMARY KEY,
    email VARCHAR(129),
    forename VARCHAR(40),
    surname VARCHAR(40),
    first_contact CHAR(10) NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_clients_pkey ON clients(client_id);
INSERT INTO nextids(table_name, next_id) VALUES('clients', 1);

CREATE TABLE sessions (
    session_id INTEGER CONSTRAINT idx_sessions_pkey PRIMARY KEY,
    client_id INTEGER,
    date CHAR(10),
    restart CHAR(10),
    notes TEXT,
    CONSTRAINT fk_client_id_sessions FOREIGN KEY (client_id) REFERENCES clients (client_id) ON DELETE RESTRICT
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_sessions_pkey ON sessions(session_id);
INSERT INTO nextids(table_name, next_id) VALUES('sessions', 1);

CREATE TABLE recordings (
    recording_id INTEGER CONSTRAINT idx_recordings_pkey PRIMARY KEY,
    session_id INTEGER NOT NULL,
    analysis INTEGER NOT NULL,
    finished CHAR(19) NOT NULL,
    product VARCHAR(40),
    product_label VARCHAR(40),
    n_pressure_rows INTEGER,
    n_pressure_cols INTEGER,
    pressure_values TEXT,
    max_pressure INTEGER,
    mask TEXT,
    results JSON NOT NULL,
    notes TEXT,
    CONSTRAINT fk_session_id_recordings FOREIGN KEY (session_id) REFERENCES sessions (session_id) ON DELETE CASCADE
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_recordings_pkey ON recordings(recording_id);
INSERT INTO nextids(table_name, next_id) VALUES('recordings', 1);
CREATE UNIQUE INDEX IF NOT EXISTS idx_recordings_analysis ON recordings(session_id,analysis) WHERE analysis <> 2;

CREATE TABLE masks (
    mask_id INTEGER CONSTRAINT idx_masks_pkey PRIMARY KEY,
    name CHAR(20) NOT NULL,
    standard INTEGER NOT NULL DEFAULT 0,
    n_rows INTEGER NOT NULL,
    n_cols INTEGER NOT NULL,
    mask TEXT NOT NULL
);
CREATE UNIQUE INDEX IF NOT EXISTS idx_masks_pkey ON masks(mask_id);

INSERT INTO masks(mask_id, name, standard, n_rows, n_cols, mask)
VALUES(1, 'nomask', 1, 28, 16,
 '0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0');
INSERT INTO masks(mask_id, name, standard, n_rows, n_cols, mask)
VALUES(2, 'standard', 1, 28, 16,
 '1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 0 0 0 1 1 0 0 0 1 1 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1');
INSERT INTO masks(mask_id, name, standard, n_rows, n_cols, mask)
VALUES(3, 'large', 1, 28, 16,
 '1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 0 0 0 0 1 1 0 0 0 0 1 1 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 1 0 0 0 0 0 0 0 0 0 0 0 0 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 0 0 0 0 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 0 0 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1' ||
' 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1');
INSERT INTO masks(mask_id, name, standard, n_rows, n_cols, mask)
VALUES(4, 'custom', 1, 28, 16,
 '0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0' ||
' 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0');


INSERT INTO nextids(table_name, next_id) VALUES('masks', 5);

