# HTTP-Domäne /vlbservice
#
# HTTP-Proxy für den Velometrik Ergonomiewebservice
#
# Zweck des Proxys ist die tranparente Ausführung verschlüsselter Webservice Requests,
# so daß Webservice-Requests über diesen Proxy wie unverschlüsselte Requests ausgeführt werden können.
# Sollte der Webservice über HTTPS angesprochen werden, sehen diese Requests im Intranet wie HTTP Requests aus.
#
# /vlbservice kann nur mit registrierten Stationen ausgeführt werden, d.h. dem Webservice müssen die Stationsnummer
# und das zugehörige Passwort (der Stationsschlüssel) bekannt sein.
#
# Einschränkung: POST-Requests können nicht weitergegeben werden, d.h.
#                Speichern des Druckbildes ist hier nicht möglich.
#                Statt dess muß die HTTP-Domäne "/storedbld" verwendet werden.
#
# Historie:
#
# 21.06.2023 Siegmar Müller Fertiggestellt
#

package require http
package require tls

namespace eval vlbservice {

    ::http::register https 443 ::tls::socket

    # Vom Webservice angekommene Daten zurückgeben
    proc dataArrived {clientsocket token} {
        upvar #0 clientcontext$clientsocket context
        upvar #0 $token state

        srvLog ${clientsocket}_[namespace current]::dataArrived Info "$context(url) -> $state(status)"
        if {$state(status) != "ok"} {
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$context(url) konnte nicht geholt werden."]
	        append html [::html::end]
            set context(responsecode) "400 Bad request"
        } else {
            set html $state(body)
            array set header $state(meta)
            if {[info exists header(Content-Type)]} {
                # Content-Type in den Header übernehmen
                srvLog ${clientsocket}_[namespace current]::dataArrived Debug2 "dataArrived, content type: $header(Content-Type)"
                # Workaround für Fehler im Webservice:
                if {[regexp {1\.[45]\.0} $::WS_VERSION]} {
                    # Fehlerhafte Version. Behauptet manchmal UTF-8 zu liefern, liefert aber ISO-8859-1
                    if {![regexp {^[1-9][0-9]* } $html]} {; # keine Fehlermeldung
                        set context(contenttype) "text/plain; charset=ISO-8859-1"
                    }
                } else {
                    #TODO Hoffentlich ?
                    # korrigierte Version
                    set context(contenttype) $header(Content-Type)
                }
            }
            ::http::cleanup $token
        }
        ::WSServer::finishDomainResponse $clientsocket $html
		srvLog $clientsocket Info "Done %d Bytes" [string length $html]
    }; # proc dataArrived 


    # Requestbehandlung
    # @param clientsocket   Schlüssel für den Clientkontext
    # @param query          GET-Parameter
    # @return               Antwort des Webservice oder Fehlertext
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context

        if {"$::WS_URL" == ""} {; #{{{ Webservice nicht konfiguriert
            # => Fehlerseite zurückgeben
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler Webservice-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "Diese Seite sollte nie zu sehen sein."]
            append html "(WS_URL nicht konfiguriert.)<BR/>"
	        append html [::html::end]
            set context(responsecode) "400 Bad request"
	        return $html
            #}}}
        }; # if Webservice nicht konfiguriert
        set ws_url "${::WS_URL}"
        if {[string index $ws_url end] != "/"} {
            append ws_url "/"
        }
        # Weiterleitung an den Webservice
        if {"$context(url)" == "/vlbservice"} {
            append context(url) "/"
        }
        set url [regsub {^.*vlbservice/} $context(url) $ws_url]
        srvLog ${clientsocket}_[namespace current]::handleClientRequest Info "geturl $url from $ws_url with {$query}"
        srvLog ${clientsocket}_[namespace current]::handleClientRequest Debug "undecoded: {$context(query)}"
        if {[catch {
            # Request verschlüsseln und ausführen
            #TODO Fehler! $query ist schon formatiert und wird hier ein 2. mal formatiert, so daß 2 x deformatiert werden müßte!
            set parameter "[::http::formatQuery {*}[join $query " "]]"
            srvLog vlbservice_$clientsocket Debug2 "Encrypting $parameter"
            set encrypted [vmkcrypt encrypt $parameter]
            set parameter "sn=$::STATION_NR&req=$encrypted"
            srvLog vlbservice_$clientsocket Debug2 "geturl $url?$parameter"
            set token [::http::geturl "$url?$parameter" -command "[namespace current]::dataArrived $clientsocket"]
            set context(self_finish) 1; # proc dataArrived kümmert sich um den Abschluß des Requests.
            set html ""
        } errmsg]} {
            srvLog $clientsocket Error "$url -> $errmsg"
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$url konnte nicht geholt werden."]
            append html $errmsg
	        append html [::html::end]
            set context(responsecode) "400 Bad request"
        }
	    return $html
    }; # proc handleClientRequest 

}; # namespace eval vlbservice 

