# lib/dbld2norm.tcl
#
# Bibliotheksmodul für die Erzeugung normierter Druckbildwerte
#
#TODO Details
#
# Die normierten Daten sind mit
#   ::tsv::get normimages $imagetype
# abrufbar.
#

#TODO Ausführung in threads

package require Thread; # Debian tclthread

namespace eval ::DBLD2NORM {
    variable normoptions [dict create -maximum 0]; # Standardoptionen:
                        # -maximum "minimales" Maximum
    variable MAX_NORM 254; # Maximalwert eines normierten Druckbildes
                           # 255 (0xFF) bleibt so als Steuerzeichen.
                           # (auch eine Standardoption, aber erst 'mal nicht konfigurierbar)


    #TODO Zukünftige Thread-Prozedur
    proc dbld2norm {cbproc imagetype normoptions druckbild n_rows n_cols} {
        # "minimales" Maximum übernehmen
        set max [dict get $normoptions -maximum]
        foreach value $druckbild {
            if {$max < $value} {
                set max $value
            }
        }
        if {$max > 0} {
            set f [expr ${MAX_NORM}.0 / $max]
            set i 0
            foreach value $druckbild {
                if {$value > 0} {
                    lset druckbild $i [expr round($value * $f)]
                }
                incr i
            }
        }
        ::tsv::set normimages $imagetype $druckbild
        $cbproc $imagetype $n_rows $n_cols
    }; # proc dbld2norm 


    # Druckbildnormierung starten (vorläufig ohne Thread)
    # @param cbproc     Name der Callbackprozedur, mit der der Absender das normierte Bild übernimmt
    #                   Der Prozeduraufruf erfolgt mit dem übergebenen Parameter imagetype.
    #                   Das fertig normierte Bild befindet sich dann im Element "$imagetype" der tsv "normimages".
    # @param druckbild  Druckwerte zeilenweise von links oben nach rechts unten
    # @param n_rows     Anzahl Zeilen
    # @param n_cols     Anzahl Spalten
    # @param imagetype  Bildtyp: Elementname im Array images im shared Memory.
    # @param alt_jpegoptions key/value Liste abweichender Normierungsoptionen
    # @return   1 gestartet
    proc startNorm {cbproc druckbild n_rows n_cols imagetype {alt_normoptions {} }} {; #{{{
        variable normoptions

        # Die alternativen Optionen in eine Kopie einbauen und so mit übergeben
        set opts [dict merge $normoptions $alt_normoptions]
        dbld2norm $cbproc $imagetype $opts $druckbild $n_rows $n_cols
        return 1
        #}}}
    }; # proc startNorm 

}; # namespace eval ::DBLD2NORM

