/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*
    Created on : 12.06.2021, 15:08:29
    Author     : Peter Bauer
*/


//TODO aufräumen Funktionen prüfen und wenn entfernen bei nicht nutzung

const host = location.origin;
const ws = host.replace('http','ws');
const apps= "satteldruckanalyse";
UIkit.modal('#modal_load_side').show();

SystemCards()

const restoreForm = document.forms.namedItem("restore2");
restoreForm.addEventListener(
    "submit",
    (event) => {
        const formData = new FormData(restoreForm);
        const request = new XMLHttpRequest();
        request.open("POST", "/db_buprest", true);
        request.onload = () => {
            if (request.status === 200) {
                OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})
            } else {
                OpenModDialog({type:'error',title:["db_upload_err"],msg:`${request.responseText}`,master_btn:['button_ok']})
            }
        };
        request.send(formData);
        event.preventDefault();
    },
    false
);

const api = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var onsqlresult = getLog();
var setting = new Object();

api.onmessage = (msg) => {
    let data = new Object();
    try {
        data = JSON.parse(msg.data)   
    } catch (error) {
        getError(error)
    }
    
    if (data.wsevent === "sqlresult"){
        try {
            onsqlresult (data.rows);           
        } catch (error) {
            getError(error)
        }
    }

}

function getLog(params) {
    console.log(params||'no SQL');
}


/**
 * !TODO Entfernen
 * It sends a request to the server to change the language file
 */
//function setLanguagefile() {
//    console.log('WERDE ICH GENUTZT?');
//    var systemsprache = document.getElementById("systemsprache").value;

//    var url = "/production/setlanguagefile.tcls?systemsprache=" + systemsprache;

//    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_system_hilfe\"><!--Einstellungen übernehmen und rebooten--></span></p>";

//    /* Sending a request to the server. */
//    httpSetconfig.open("GET", url, true);
//    httpSetconfig.send();

//    translatejs();
//}

/**
 * It sends a request to the server to set the configuration file
 */
function setConfigfile() {
    let stationsnummer = document.getElementById("stationsnummer").value;
    
    /*The "encodeURIComponent()" function is used to encode the value of the input to make it safe to be used in a URL. */
    let farbe = encodeURIComponent(document.getElementById("farbe").value);
    let empfindlichkeit = document.getElementById("empfindlichkeit").value;
    let webservice = document.getElementById("webservice").value;
    let url_smartcube = document.getElementById("url_smartcube").value;
    let login_mail = document.getElementById('system_login_mail').value;
    let login_pass = document.getElementById('system_login_pass').value;
    /* The above code is checking if the variable `url_smartcube` contains the string "http://". If it
    does, it splits the string at "http://" and takes the second part of the split (i.e. the part after
    "http://"). Then it replaces all forward slashes ("/") in that part with an empty string and assigns
    the resulting string back to `url_smartcube`. Essentially, it is removing the "http://" and any
    forward slashes from the URL. */
    if(url_smartcube.includes('http://')){
        let url = url_smartcube.split('http://')[1]
        url_smartcube = url.replaceAll('/','')
    }
    script_setting.smartcube = url_smartcube
    script_setting.LoginMail = login_mail
    script_setting.LoginPass = login_pass
    saveConfig()
    //var url = "/production/setconfigfile.tcls?stationsnummer=" + stationsnummer + "&farbe=" + farbe + "&empfindlichkeit=" + empfindlichkeit + "&webservice=" + webservice + "&url_smartcube=" + url_smartcube;
    const url = `/production/setconfigfile.tcls?stationsnummer=${stationsnummer}&farbe=${farbe}&empfindlichkeit=${empfindlichkeit}&webservice=${webservice}`;//&url_smartcube=${url_smartcube}`;

    /* Sending a request to the server. */
    httpSetconfig.open("GET", url, true);
    httpSetconfig.send();


    OpenModDialog({type:'warn',title:["config_reinit"],msg:`${aLangKeys[lang]['new_init']}`,master_btn:['button_ok','reinit()']})

}


/**
 * The function `downloadFile` is used to download a file and display a message based on the response.
 * @returns The function does not explicitly return a value.
 */
function downloadFile() {
    const updatefile = document.getElementById("updatefile").value;
    
    /* The above code is a JavaScript function that is triggered when a file update is requested. */
    if (updatefile) {
        gears_on()
        const url = `vlbupdate.tcls?updatefile=${updatefile}`;
        const oReq = new XMLHttpRequest();

        oReq.open("GET", url, true);
        oReq.send();

     /* The above code is handling the response from an XMLHttpRequest (AJAX) request. */
        oReq.onload = (e) => {
            if(oReq.status === 500){
                setTimeout(()=>{gears_off()},1000)
            }
            const arraybuffer = oReq.response; 
            if (arraybuffer.includes("Error: 500")) {
                document.getElementById("updatemassage").value = aLangKeys[lang]["update_fail"]//"UPDATE FAILED"
                return;
            }
            document.getElementById('updatemassage').value = arraybuffer
            setTimeout(()=>{gears_off()}, 500);
            setTimeout(()=>{setReboot()},1500)
        }
        translatejs();
        return;
    }
    document.getElementById("updatefile").style.border = "1px solid red";
    document.getElementById("updatefile").style.background = "#ffd6d6";
    document.getElementById("updatefile").setAttribute("placeholder", "e.g. vlbupdate-XXX.tar.gz");
}

/**
 * "When the user clicks on the gear icon, show the gear modal."
 * 
 * The `console.log` statement is a debugging tool. It's a way to print out a message to the browser's
 * console
 */
function gears_on() {
    console.log('show gear');
    $('#gear').modal('show');
}

/**
 * "When the user clicks the gear icon, hide the gear modal."
 * 
 * The first line of the function is a console.log statement. This is a debugging tool that will print
 * the text "hide gear" to the console
 */
function gears_off() {
    $('#gear').modal('hide');
}
/**
 * It shows a modal dialog with a message
 */
function setReboot() {

    // Request starten
    document.getElementById("message").innerHTML = "<p><span class=\"tr\" key=\"system_rebootvelobox\"><!--Reboot Velobox--></span></p>";

    translatejs();

    $("#reboot").modal('show');
}

/* The above code is checking the value of `script_setting.bg` and applying different CSS classes to
elements with the class name 'back' based on that value. If the value matches the class value of the
second child node of the element, it adds the class 'mdi-checkbox-marked-circle-outline' and removes
the class 'mdi-checkbox-blank-circle-outline'. If the value does not match, it removes the class
'mdi-checkbox-marked-circle-outline' and adds the class 'mdi-checkbox-blank-circle-outline'. */
if(script_setting.bg){
    for (let name of document.getElementsByClassName('back')) {
        if(name.childNodes[1].classList.value === script_setting.bg){
            name.classList.remove('mdi-checkbox-blank-circle-outline');
            name.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            name.classList.remove('mdi-checkbox-marked-circle-outline');
            name.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
} 

/**
 * The function `selectBack` updates the background color of an element and sends the updated settings
 * to a WebSocket server.
 * @param params - params is a parameter that represents the selected element. It is expected to be a
 * DOM element that contains child nodes.
 */
function selectBack(params) {
    script_setting.bg = params.childNodes[1].classList.value
    script_websocket.send(`set clientsettings ${JSON.stringify(script_setting)}`)

    let b = document.getElementsByClassName('right_col')[0]
    b.removeAttribute('class');
    b.classList.add(params.childNodes[1].classList.value,'right_col');

    for (let n of document.getElementsByClassName('back')) {
        if(n.childNodes[1].classList.value === script_setting.bg){
            n.classList.remove('mdi-checkbox-blank-circle-outline');
            n.classList.add('mdi-checkbox-marked-circle-outline');
        } else{
            n.classList.remove('mdi-checkbox-marked-circle-outline');
            n.classList.add('mdi-checkbox-blank-circle-outline');
        }
    }
    //setting.bgImage = params.childNodes[1].classList.value;
}

/**
 * If the parameter is 'on', set the local storage item 'DarkMode' to 0, otherwise remove the local
 * storage item 'DarkMode' and reload the page.
 * @param params - The parameter that is passed to the function.
 */
function DarkMode(params) {
    if(params==='on'){
      localStorage.setItem('DarkMode',0)
      setting.darkMode = 1
    } else {
      localStorage.removeItem('DarkMode')
      setting.darkMode = 0
    }
    //setSetting()
    location.reload()
    }

/**
 * The function creates a list of settings with icons and labels using HTML and CSS classes.
 * @param list - The `list` parameter is an array of arrays, where each inner array contains two
 * elements: the first element is a string representing the setting name, and the second element is a
 * string representing the icon to be displayed for that setting.
 */
function Setting_List(list) {
    let append = document.getElementById('system-card-holder');
    list.forEach(element => {
        let div = newElement({element:'div'},append)
        let i = newElement({element:'i',cls:['readme_card','readme','mdi','mdi-help-circle-outline'],attr:[['key-title','ReadMe_title_help'],['key-readme',`Help_${element[0]}`],['onclick',`OpenReadMe('Help_${element[0]}')`]]},div)
        let uk_card = newElement({element:'div',cls:['uk-card','uk-card-default','cur_pointer','dash-card'],attr:[['onclick',`OpenSetting('${element[0]}')`],['key-title',`${element[0]}`]]},div)
        let uk_card_header = newElement({element:'div',cls:['uk-card-header','flex-column-center']},uk_card)
        let mdi = newElement({element:'div',cls:['mdi',`${element[1]}`],attr:[['style','font-size: 100px;']]},uk_card_header)
        let uk_card_body = newElement({element:'div',cls:['uk-card-body','uk-padding-small','uk-text-center'],attr:[['key',`${element[0]}`]]},uk_card).innerHTML = `<!--${element[0]}-->`
    }); 
    translatejs()
}
/**
 * The function opens a UIkit modal with the ID corresponding to the input SettingName.
 * @param {String}SettingName - The parameter `SettingName` is a string that represents the name of the setting
 * that needs to be accessed or modified. It is used as a reference to open the corresponding modal
 * window with the settings options.
 */
function OpenSetting(SettingName) {
    UIkit.modal(`#modal-${SettingName}`).show();
}

/**
 * The function "addDate" sets the download attribute of an element with the id "startBackup" to a
 * formatted date string.
 */
function addDate() {
    const d = new Date();
    document.getElementById("startBackup").download = `VeloboxBup_${d.getFullYear() * 10000 + (d.getMonth() + 1) * 100 + d.getDate()}`;
}

/**
 * The function `SystemCards` fetches a JSON file containing system cards and passes the data to the
 * `Setting_List` function, while handling any errors with the `getError` function.
 */
function SystemCards() {
    try {
      fetch("/production/json/cards.json", {
        mode: "no-cors",
      }) // disable CORS because path does not contain http(s)
      .then((res) => res.json())
      .then((data) => (Setting_List(data.systemcards)));
    } catch (error) {
      getError(error)
    }
}


try {
    fetch("https://downloads.velometrik.de/version.json")
    .then((res)=> res.json())
    .then((data)=> update_jsn(data))
  } catch (error) {
    console.error(error);
  }
  function update_jsn(jsn) {
    let comp = setInterval(()=> {
    console.log(jsn.versionen);
    let aV = htdocsInfo.VERSION.replaceAll('.','')
    var i = 0
    if(document.getElementById('updatefile')){
      var t = document.getElementById('updatefile')
      jsn.versionen.forEach(e => {
        let nV = e.version.replaceAll('.','')
        if (aV < nV && i==0) {
            i++;
            t.value = e.name;
            return;
        }
      });
    }
    clearInterval(comp);
    }, 500);

  }