/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/
const host = `http://${location.host}`;
const ws = `ws://${location.host}`;
const apps= "satteldruckanalyse";
function ToggleLog() {
    if(localStorage.getItem('log')===false||false){
        localStorage.setItem('log',true)
        log=true
    } else{
        localStorage.setItem('log',false)
    }
}

const session = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);

var fi = 0
var recID =[];

localStorage.setItem('session',"")
localStorage.setItem('session_note',"")
localStorage.removeItem('sessionID')
/* A variable that is used to store a function that is called when the server sends a message to the
client. */
var onsqlresult = getLog;

function getLog(params){
    console.log(params);
}



var galerie_image_info = {};

session.onopen = (e) => {
    if(location.pathname === "/production/clients.tcls"){
        document.getElementById('loader').classList.add('hidden')
        end_session()
        onsqlresult = clients_list;
        session.send(`sql select * from clients order by client_id desc`)
    }
};

var galerie_image_info = {};

/* A function that is called when the server sends a message to the client. */
session.onmessage = (e) => {

    var data = new Object();
    try {
       data = JSON.parse(e.data);
    } catch (error) {
        getError(error)
    }

    if (data.wsevent === "sqlresult"){
        onsqlresult (data.rows);
    }
    if(data.wsevent === "result3"){
        galerie_image_info = data;
    }
    if (data.wsevent === "sda_int3") {
        var pel;
        // console.log(galerie_image_info);
        sda_frame3 = `${host}/sattelbild?image=sda_int3&rnd=${(new Date).getTime()}`;
        document.getElementsByClassName('imgGal1')[fi-1].src=sda_frame3
        // if(galerie_image_info.pelvisrotation)
        // pel = `${galerie_image_info.pelvisrotation.width||""}:${galerie_image_info.pelvisrotation.height||""}`
        // else
        // pel ="-"
        // document.getElementsByClassName('info_img')[fi-1].innerHTML =`
        // <ul class="uk-list uk-list-collapse">
        // <li>Veloscore</li>
        // <li>Rotation</li>
        // <li>Lins/Rechts</li>
        // <li>Vorn/Hinten</li>
        // </ul>
        // <ul class="uk-list uk-list-collapse">
        // <li>${galerie_image_info.veloscore}</li>
        // <li>${pel}</li>
        // <li>${galerie_image_info.left_right}</li>
        // <li>${galerie_image_info.front_rear}</li>
        // </ul>`

        if(recID[fi]){
            // console.log('wsevent int3 send');
            session.send(`recording retrieve ${recID[fi]}`)
            fi++
        }
    }

}

/**
 * It sends a message to the server to start a new session
 * @param {boolean} bool - if true, the user will be redirected to the next page, if false, the session will be
 * finished.
 */
function new_session(bool) {
    const form = document.forms.namedItem("session_form");
    if(form.forename.value != "" && form.surname.value != "" && bool === true){
        localStorage.setItem('session',`start {"forename":"${form.forename.value}","surname":"${form.surname.value}","email":"${form.email.value||""}"}`)
        localStorage.setItem('client_name',`${form.forename.value} ${form.surname.value}`)
        localStorage.setItem('client_mail',`${form.email.value||""}`)
        localStorage.setItem('client_forenames',`${form.forename.value}`)
        localStorage.setItem('client_surename',`${form.surname.value}`)
        location.pathname = '/production/saddle_pressure_analysis.tcls'
    } else{
        if(form.forename.value === "")
        form.forename.setAttribute('style','border: 1px solid red')
        if(form.surname.value === "")
        form.surname.setAttribute('style','border: 1px solid red')
    }
    if(form.forename.value != "" && form.surname.value != "" && bool === false){
        session.send(`session start {"forename":"${form.forename.value}","surname":"${form.surname.value}","email":"${form.email.value||""}"}`)
        session.send(`session finish`)
        location.pathname = '/production/clients.tcls'
    } else{
        if(form.forename.value === "")
        form.forename.setAttribute('style','border: 1px solid red')
        if(form.surname.value === "")
        form.surname.setAttribute('style','border: 1px solid red')
    }

}

/**
 * It sends a message to the session.
 */
function end_session(){
    session.send('session finish')
}

/**
 * It takes an array of objects and creates a table with the objects as rows.
 * @param {String[]} array - the array of objects that you want to display
 */
function clients_list(array) {
    onsqlresult=getLog;
    var thead = ['#','Datum der Messung','Name/Vorname','Email']//,'new Session','']
    var append = $('#clients-list')[0]
    var container = document.createElement('div')
    container.classList.add('uk-container','uk-padding-remove')
    append.append(container)
    var table = document.createElement('table')
    table.classList.add('uk-table','uk-table-middle','uk-table-divider','uk-table-hover')
    container.append(table);
    var table_head= document.createElement('thead')
    table.append(table_head);
    var tr_head = document.createElement('tr');
    table_head.append(tr_head);
    thead.forEach(element => {
        var head = document.createElement('th');
        head.setAttribute('key',element)
        head.innerHTML = element
        tr_head.append(head);
    })
    var tbody = document.createElement('tbody');
    table.append(tbody);

    array.forEach(element => {
        var x = new Object;
        x = element;
        var tr_body = document.createElement('tr');
        tr_body.classList.add('suche')
        tr_body.setAttribute('suche',`${x.surname||""} ${x.forename||""} ${x.first_contact} ${x.email||""}`)
        tbody.append(tr_body);
        tr_body.innerHTML =  `<td onclick="info(${x.client_id},'${x.surname||""} ${x.forename||""}','${x.forename||""}','${x.surname||""}','${x.email||""}','${x.first_contact}')">${x.client_id}</td>`
        tr_body.innerHTML += `<td onclick="info(${x.client_id},'${x.surname||""} ${x.forename||""}','${x.forename||""}','${x.surname||""}','${x.email||""}','${x.first_contact}')">${x.first_contact}</td>`
        tr_body.innerHTML += `<td onclick="info(${x.client_id},'${x.surname||""} ${x.forename||""}','${x.forename||""}','${x.surname||""}','${x.email||""}','${x.first_contact}')">${x.forename||""} ${x.surname||""}</td>`
        tr_body.innerHTML += `<td onclick="info(${x.client_id},'${x.surname||""} ${x.forename||""}','${x.forename||""}','${x.surname||""}','${x.email||""}','${x.first_contact}')">${x.email||""}</td>`
        // tr_body.innerHTML += `<td><button class="uk-button uk-button-default uk-button-small" uk-icon="icon: play" onclick="new_session_id(${x.client_id})" uk-tooltip="Neue Sitzung"></button></td>`
         tr_body.innerHTML += `<td><button class="uk-button uk-button-default uk-button-small adba basicview ico-16 mdi mdi-trash-can-outline" onclick="ClientDel(${x.client_id})"></button></td>`
    });
    ToggleViewMode(localStorage.getItem("viewmode"));
    translatejs()
}

/**
 * `ClientInfo` is a function that takes a single parameter, `params`, and stores it in local storage
 * @param params - {
 */
function ClientInfo(params) {
    onsqlresult = getLog;
    localStorage.setItem('client_info',JSON.stringify(params));
}

/**
 * It takes three arguments, sends a query to the database, and then creates a table with the results
 * of the query
 * @param {number}client_id - The client's ID
 * @param {string}name - The name of the client
 * @param {string}mail - The email address of the user.
 */
function info(client_id,name,fname,lname,mail,fc) {
    onsqlresult = ClientInfo
    session.send(`sql select * from sessions where client_id=${client_id}`);
    //append1 = document.getElementById('imagelist');
    //append1.innerHTML = "";
    let inter = setInterval(()=> {
        localStorage.setItem('client_fc',fc)
        localStorage.setItem('client_name',name)
        localStorage.setItem('client_mail',mail)
        localStorage.setItem('client_id',client_id)
        localStorage.setItem('client_forenames',fname)
        localStorage.setItem('client_surename',lname)
        location.href = "/production/client.tcls"
        clearInterval(inter);
      }, 500);

}

/**
 * It sets the title of the modal to the session number and shows the modal
 * @param params - The name of the session to be deleted
 */
function SessionDel(params) {
    let text = `${aLangKeys[lang]['cli_session_del1']}${params} ${aLangKeys[lang]['cli_session_del2']}`
    OpenModDialog({type:'warn',title:text,msg:["cli_session_text"],master_btn:['button_delete','SelectSessionDel()'],slave_btn:['button_cancel']})
    localStorage.setItem('del_session', params)
}

function ClientDel(params) {
    let text = `${aLangKeys[lang]['cli_client_del1']}${params} ${aLangKeys[lang]['cli_session_del2']}`
    OpenModDialog({type:'warn',title:text,msg:["cli_client_text"],master_btn:['button_delete','SelectCliDel()'],slave_btn:['button_cancel']})
    localStorage.setItem('del_cli', params)
}

function SelectCliDel() {
    session.send(`sql delete from sessions where client_id=${localStorage.getItem('del_cli')}`)
    session.send(`sql delete from clients where client_id=${localStorage.getItem('del_cli')}`)
    location.reload()
}

/**
 * It deletes the session and all recordings associated with it
 */
function SelectSessionDel() {
    session.send(`sql delete from recordings where session_id=${localStorage.getItem('del_session')}`)
    session.send(`sql delete from sessions where session_id=${localStorage.getItem('del_session')}`)
    let del = document.getElementById(`cli_${localStorage.getItem('del_session')}`)
    del.classList.add('hidden')
}

/**
 * It takes an array of objects as a parameter, and for each object in the array, it creates an image
 * element, sets the width and height, and adds a class to the image element
 * @param params - The array of objects returned from the SQL query.
 */
function RowImg(params) {
    // session.send()
    if(params.length == 0){
        document.getElementById('pi_retriveSession').innerHTML = `<button key="cli_NoSession" class="uk-button uk-button-primary uk-modal-close"><!--fortsetzen--></button>`;
    }
    fi = 0;
    recID = [];
    onsqlresult = getLog;
    var append1 = document.getElementById('imagelist')
    append1.innerHTML ="";
    console.log('params',params);
    params.forEach(element => {
            if(fi===0){
                console.log('session:RowImg send');
                session.send(`recording retrieve ${element.recording_id}`)
                fi++
            }
            recID.push(element.recording_id)
            let div = document.createElement('div');
            div.setAttribute('style','border:1px solid green;margin: 5px;')
            append1.append(div);
            let img = document.createElement('img');
            img.width=100
            img.height=100
            img.classList.add('imgGal1')
            div.append(img)
            let div_info = document.createElement('div');
            div_info.classList.add('uk-grid','uk-child-width-1-2','info_img')
            div_info.setAttribute('style','margin: 0 -30px;')
            // div_info.innerHTML =`<ul><li>data</li></ul><ul><li>${galerie_image_info.product_label}</li></ul>`
            div.append(div_info)
    });
}

/**
 * `session_img(session_id)` is a function that sends a SQL query to the database to get the image
 * associated with the session_id.
 * @param session_id - The session ID of the recording you want to retrieve.
 */
function session_img(session_id,note) {
    onsqlresult = RowImg
    if(location.pathname === '/production/client.tcls'){
        document.getElementById('details_info').innerHTML = note || session_id;
        document.getElementById('pi_retriveSession').innerHTML = `<button key="cli_to_pdf" onclick='toProtokoll(${session_id})' class='uk-button uk-button-default'><!--protokoll--></button>
                                                                  <button key="cli_retrive" onclick='rest_session(${session_id},"${note}")' class="uk-button uk-button-primary"><!--fortsetzen--></button>`;
        UIkit.modal('#modal_details').show(); 
    }
    translatejs();
    localStorage.setItem('session_note',note)
    // session.send(`sql select * from recordings where session_id=${session_id}`)
    session.send(`sql SELECT * FROM recordings WHERE analysis=2 AND session_id=${session_id} ORDER BY finished`)
}

/**
 * `rest_session(id)`
 * 
 * This function is called when the user clicks the "Restart" button. It sends a message to the server
 * that the session is finished, and then redirects the user to the start page
 * @param id - the id of the session
 */
function rest_session(id,note){
    session.send('session finish');
    localStorage.setItem('session',`restart ${id}`)
    localStorage.setItem('session_note',note)
    location.href = '/production/saddle_pressure_analysis.tcls'
}

/**
 * It sends a message to the server that the session is finished, then it sets the session id in the
 * local storage, and then it redirects the user to the next page
 * @param id - the id of the session
 */
function new_session_id(id){
    session.send('session finish');
    localStorage.setItem('session',`start ${id}`)
    localStorage.setItem('session_note',"")
    // DEF SITZKNOCHEN
    // location.href = '/production/new_sitzknochen.tcls'
    location.href = '/production/saddle_pressure_analysis.tcls'
}


/**
 * It searches for the given parameter in the attribute 'suche' of all elements with the class 'suche'
 * and shows the elements that contain the parameter.
 * @param params - The search term
 */
function suche(params) {
    $('.suche').each(element => {
        $('.suche')[element].classList.add('hide')
        if($('.suche')[element].getAttribute('suche').includes(params)|| $('.suche')[element].getAttribute('suche').toLowerCase().includes(params))
        $('.suche')[element].classList.remove('hide')
    });
}