# Webservicedomäne /messages
# Austausch bestimmter Statusmeldungen zwischen Arbeitsstation und Clientbrowser
namespace eval messages {
    # Variablen für diese Domäne
    # variable ...

    # Meldung über verfügbares JPEG-Livebild von ::kernel::JPEGSattel entgegennehmen
    proc jpegAvailable {imagetype} {
        if {"$imagetype" == "sattel_live"} {
            ::WSServer::disposeServerMessage messages text "{\"wsevent\": \"sattelbild\"}"
        }
    }


    # Mitteilung vom Client verarbeiten
       # Hinweis: Das ist ein Callback, das mit ::websocket::live übergeben wird.
       # Es wird von ::websocket aufgerufen und befindet sich deshalb in einem
       # anderen namespace Kontext.
       # Prozeduren aus ::WSServer müssen deshalb mit vollem Namespacepfad
       # aufgerufen werden.
    proc handleClientMessage {clientsocket type msg} {
	    upvar #0 clientcontext$clientsocket context
           # variable ...
	
	    # type laut API:
	    #   text        Complete text message
	    #   binary      Complete binary message
	    #   ping        Incoming ping message
	    #   connect     Notification of successful connection to server
	    #   disconnect  Disconnection from remote end
	    #   close       Pending closure of connection
	
	    switch -glob -nocase -- $type {
	        connect {
	            srvLog $clientsocket Info "Client connected"
                # Aktuellen Status an neuen Client senden
                # Dabei handelt es sich um die angeschlossenen Matten.
                #TODO ::matten entfällt. Die Informationen dort stecken in TTYHocker und TTYSattel
                #       Folgendes muß deshalb nach TODO wohin? verlagert werden.
                foreach matte [array names ::matten] {
                    ::websocket::send $clientsocket text [::kvlist2json [list wsevent plugged driver $matte type $::matten($matte)]]
                }
                # Callback setzen
                ::kernel::JPEGSattel::addImageHandler [namespace current]::jpegAvailable sattel_live
	        }
	        text {
	            srvLog $clientsocket Notice "text message received:\n'$msg'"
	        }
	        binary {
	            srvLog $clientsocket Info "binary message received"
	        }
	        ping -
	        pong {
	            srvLog $clientsocket Debug "Client $type received"
                   # Kein Handlungsbedarf
	        }
	        close {
				srvLog $clientsocket Info "WS-Connection closing (%s)" $context(ipaddr)
                   # Kein Handlungsbedarf
	        }
	        disconnect {
				srvLog $clientsocket Info "WS-Connection disconnected (%s)" $context(ipaddr)
                # Callback zurücknehmen
                ::kernel::JPEGSattel::removeImageHandler [namespace current]::jpegAvailable
                # Das ist notwendig:
	            ::WSServer::wsClientKill $clientsocket
            }
	        default {
				srvLog $clientsocket Info "WS-Connection unknown message type: %s" $type
                   # Kein Handlungsbedarf
	        }
	    }
    }; # proc handleClientMessage 

}; # namespace eval messages 

