/*
Copyright (C) 2021 Velometrik GmbH
<http://www.velometrik.de/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* 
    Created on : 04.06.2021, 21:08:29
    Author     : Peter Bauer
*/

const host = location.origin;
const ws = host.replace('http','ws');
const apps= "satteldruckanalyse";

var sessionID;
if(localStorage.getItem('session').split(" ")[0]=='restart'){
  sessionID = localStorage.getItem('session').split(" ")[1]
} else{
  sessionID = localStorage.getItem('new_session')
}

var onsqlresult = null;
var load_num;
var galerie_image_info = {};
var recID;
var recData={};
let gal=[]
var img1;
var img2;
var chk1;
var chk1;
var ch,cw;
var chart_a;
var chart_b;
var max=0;
ch = document.getElementsByClassName("frameX")[0].offsetHeight;
cw = document.getElementsByClassName("frameX")[0].offsetWidth;

let sda_frame1 = `${host}/sattelbild?image=blank`;
let sda_frame2 = `${host}/sattelbild?image=blank`;
let sda_frame3 = `${host}/sattelbild?image=blank`;

const canvas1 = new fabric.Canvas("canvas_1");
const canvas2 = new fabric.Canvas("canvas_2");

const mail = document.getElementById('mail');

//if(localStorage.getItem('client_mail') != "" && localStorage.getItem('client_mail').includes('@')){
//    mail.classList.remove('hidden')
//}

createCanvas(canvas1);
createCanvas(canvas2);


var BigImage = {}

// translatejs();


/**
 * This function takes a fabric.js canvas object and an image URL, and adds the image to the canvas.
 * @param params - the canvas object
 * @param img - The image to be loaded
 */
function setImage(params, img) {
    fabric.Image.fromURL(img, function (oImg) {
      oImg.scaleToWidth(cw);
      oImg.hasControls = false;
      oImg.set("selectable", false);
      params.add(oImg);
    });
}

/**
 * `createCanvas` is a function that takes a parameter called `params` and sets the `params.selection`
 * to `false`, `params.hasControls` to `false`, `params.lockMovement` to `false`, `params.setHeight` to
 * `ch`, and `params.setWidth` to `cw`
 * @param params - The object that contains the parameters for the canvas.
 */
function createCanvas(params) {
    params.selection = false; // disable group selection
    params.hasControls = false;
    params.lockMovement= false;
    params.setHeight(ch);
    params.setWidth(cw);
}

try {
    var sattelanalyse = new WebSocket(`${ws}/apps/${apps}`, ["soap", "wamp"]);
} catch (error) {
    getError(error)
}

        _name();
        // _sitzknochen();
        _satteldruckanalyse();


/**
 * It gets the name from local storage and puts it in the right places
 */
function _name() {
    let auswertung_h3 = document.getElementsByClassName('headliner')[0];
    auswertung_h3.removeAttribute('key')
    let name = localStorage.getItem('client_name').split(' ')
    auswertung_h3.innerHTML += ' '+name[1]+" "+name[0]
    document.getElementById('name_vorname').innerHTML = name[0]+', '+name[1] 
}

/**
 * It gets the data from the local storage and puts it into the HTML
 */
function _sitzknochen(){
    let sitzkochen = JSON.parse(localStorage.getItem('smartcube'))
    let sk = 0
    if(!script_setting.UserUnit || script_setting.UserUnit === "cm"){
        sk = sitzkochen.sitzknochenabstand
    }
    if(script_setting.UserUnit === "in"){
        sk =(sitzkochen.sitzknochenabstand/2.54).toFixed(2)
    }
    document.getElementById('sitzknochenabstand').innerHTML = sk
    document.getElementById('disbalance').innerHTML = sitzkochen.disbalance
    document.getElementById('einsatzbereich').innerHTML = sitzkochen.einsatzbereich
    document.getElementById('fahrgewohnheit').innerHTML = sitzkochen.fahrgewohnheit
    document.getElementById('sitzposition').innerHTML = sitzkochen.sitzposition
    document.getElementById('IMG').src = sitzkochen.img
}


/**
 * It opens a websocket connection to the server, and sends a few commands to it
 */
function _satteldruckanalyse() {
    sattelanalyse.onopen = (e)=>{
        rec_cancel(1);
        rec_cancel(2);
        onsqlresult = RowImg
        sattelanalyse.send(`sql select * from recordings where session_id=${sessionID} and analysis='2'`)
        // sattelanalyse.send(`session retrieve ${sessionID}`)
        sattelanalyse.send(`session restart ${sessionID}`)
        sattelanalyse.send('set compare on')
        // sattelanalyse.send('get appquestions')
        sattelanalyse.send(`analysis ["sitbones","anamnesis","x1"]`)

        PrintLog(['_satteldruckanalyse',`sql select * from recordings where session_id=${sessionID} and analysis='2'`])
        PrintLog(['_satteldruckanalyse',`session restart ${sessionID}`])
        PrintLog(['_satteldruckanalyse',`set compare on`])
        PrintLog(['_satteldruckanalyse',`analysis ["sitbones","anamnesis","x1"]`])
    }
}

function rec_cancel(num) {
    sattelanalyse.send(`recording cancel ${num}`);
    PrintLog([`recording cancel ${num}`])
}

var analysis = new Object();
analysis.sitbones = new Object();
analysis.anamnesis = new Object();
analysis.x1 = new Object();
//{"sitbones":{"sitzknochenabstand":"","asymmetrie":""}}

/**
 * The function `store` takes in a value, a key, and an analysis object, and stores the value in the
 * analysis object using the key. It then sends the updated analysis object to a server and logs the
 * action if the `log` variable is true.
 * @param val - The `val` parameter represents the value that you want to store in the `analysis`
 * object.
 * @param key - The `key` parameter is a string that represents the key or property name in the
 * `analysis` object. It is used to access and modify the value associated with that key in the
 * `analysis` object.
 * @param a - The parameter 'a' is used as an index to access a specific element in the 'analysis'
 * array.
 */
function store(val,key,a) {
    PrintLog(['store',val])
    PrintLog(['store',key])
    PrintLog(['store',a])
    PrintLog(['store',analysis[a][key]])

    analysis[a][key] = val

    for (const key in analysis) {
            const element = analysis[key];
            sattelanalyse.send(`analysis {"${key}":${JSON.stringify(element)}}`)
            if(log)
            console.log('store',`analysis {"${key}":${JSON.stringify(element)}}`);
    }
    
}


/**
 * The function `bigImage` adds a class to a canvas element and its parent element, and attaches a
 * click event listener to the canvas element.
 * @param num - The parameter `num` is used to identify the specific canvas element that needs to be
 * manipulated. It is used to generate the id of the canvas element by concatenating it with the string
 * "canvas_".
 */
function bigImage(num) {
  BigImage = document.getElementById(`canvas_${num}`)
    BigImage.classList.add('bigCanvas')
    BigImage.parentElement.classList.add('imgageBefore')
    document.getElementById(`canvas_${num}`).addEventListener('click',imageBig)

}




/**
 * The function toggles the class of an image element to make it bigger or smaller when clicked.
 */
function imageBig() {
    console.log('click');
if(BigImage.classList.contains("bigCanvas")){
    BigImage.classList.toggle('bigCanvas');
    BigImage.parentElement.classList.toggle('imgageBefore')
    BigImage = {}
}
}
/**
 * It takes a parameter, and logs it to the console
 * @param params - {
 */
function getLog(params){
    console.log(params);
  }
/**
 * `ClientInfo` is a function that takes a single parameter, `params`, and stores it in local storage
 * @param params - {
 */
function ClientInfo(params) {
    onsqlresult = getLog;
    localStorage.setItem('client_info',JSON.stringify(params));
  }
  /**
   * It takes three arguments, sends a query to the database, and then creates a table with the results
   * of the query
   * @param {number}client_id - The client's ID
   * @param {string}name - The name of the client
   * @param {string}mail - The email address of the user.
   */
  function info(client_id,name,fname,lname,mail,fc) {
    onsqlresult = ClientInfo
    sattelanalyse.send(`sql select * from sessions where client_id=${client_id}`);
    append1 = document.getElementById('imagelist');
    append1.innerHTML = "";
    let inter = setInterval(()=> {
        localStorage.setItem('client_fc',fc)
        localStorage.setItem('client_name',name)
        localStorage.setItem('client_mail',mail)
        localStorage.setItem('client_id',client_id)
        localStorage.setItem('client_forenames',fname)
        localStorage.setItem('client_surename',lname)
        location.href = "/production/client.tcls"
        clearInterval(inter);
      }, 500);
  
  }


sattelanalyse.onmessage = (e) => {
        let data = JSON.parse(e.data)
        if(log)
        console.log('sattelanalyse.onmessage',data);
        // console.log(data);
        if (data.wsevent === "sda_int1") {
        // console.log("sda_init1",data);
        sda_frame1 = `${host}/sattelbild?image=sda_int1&rnd=${(new Date).getTime()}`;
            // document.getElementById('sda1').src = sda_frame1
            setImage(canvas1,sda_frame1)
        }
        if (data.wsevent === "sda_int2") {
        // console.log(data);
        sda_frame2 = `${host}/sattelbild?image=sda_int2&rnd=${(new Date).getTime()}`;
            // document.getElementById('sda2').src = sda_frame2
            setImage(canvas2,sda_frame2)
        }
        if (data.wsevent === "result1") {
        // console.log(data);
        result_1(data);
        }
        if (data.wsevent === "result2") {
        // console.log(data);
        result_2(data);
        }
        if (data.wsevent === "result3"){
            // console.log(data)
            galerie_image_info = data;
        }
        if (data.wsevent === "sqlresult"){
            // console.log(data)
            try {
            onsqlresult (data.rows);           
            } catch (error) {
                getError(error)
            }
        }
        if (data.wsevent === "analyses"){
            let d = data.analyses;
            for (const key in d) {
                    const element = d[key];
                    for (const key2 in element) {
                            const element2 = element[key2];
                            let ele = document.getElementById(key2)
                            ele.value = element2
                            // console.log(key,key2,element2);
                            analysis[key][key2]=element2
                    }
            }
        }
        if (data.wsevent === "sda_int3") {
            // console.log('sda_int3');
            let img = document.getElementsByClassName('imgGal1')[fi-1];
            let a = document.getElementsByClassName('imgGal2')[fi-1];
            sda_frame3 = `${host}/sattelbild?image=sda_int3&rnd=${(new Date).getTime()}`;
            img.src=sda_frame3
            a.setAttribute('onclick',`getImgData(${fi-1},this)`)
            gal[fi-1]=JSON.stringify(galerie_image_info)
            recData[recID[fi-1]] = JSON.stringify(galerie_image_info)
            //a.setAttribute('onclick',`sattelanalyse.send('recording retrieve ${recID[fi-1]} ${load_num}')`)
            if(galerie_image_info.pelvisrotation)
              pel = `${galerie_image_info.pelvisrotation.width||""}:${galerie_image_info.pelvisrotation.height||""}`
            else
              pel ="-"
            document.getElementsByClassName('info_img')[fi-1].innerHTML =`
            <ul class="uk-list uk-list-collapse">
            <li key="pro_satteldruck_veloscore">Veloscore</li>
            <li key="pro_satteldruck_becken">Rotation</li>
            <li key="pro_satteldruck_leftright">Lins/Rechts</li>
            <li key="pro_satteldruck_frontback">Vorn/Hinten</li>
            </ul>
            <ul class="uk-list uk-list-collapse">
            <li>${galerie_image_info.veloscore}</li>
            <li>${pel}</li>
            <li>${galerie_image_info.left_right}</li>
            <li>${galerie_image_info.front_rear}</li>
            </ul>
            <textarea readonly class="uk-textarea" style="width:150px;height: 60px;margin-left:30px ">${galerie_image_info.notes}</textarea>`
           document.getElementsByClassName('name_img')[fi-1].innerHTML=`
           <h2 class="uk-text-center">${galerie_image_info.product_label||aLangKeys[lang]['sda_marke']}</h2>
           <p class="uk-text-center"><small>${galerie_image_info.product||aLangKeys[lang]['sda_typ']}</small></p>`

            /* Sending a message to the sattelanalyse object. */
            if(recID[fi]){
                sattelanalyse.send(`recording retrieve ${recID[fi]} 3`)
                fi++
            }
        }
        
        if (data.wsevent === "appquestions") {
            console.log(data.appquestions);
        }
    
    
}

/**
 * It sends a SQL query to the server, and when the server responds, it calls the function RowImg
 * @param num - the number of the recording to load
 */
function load_rec(num) {
    load_num = num
    let btn = document.getElementById('img_select_btn');
    btn.setAttribute('disabled','')
  
    // console.log('load ',num);
    if(localStorage.getItem('session').split(' ')[0]=='restart'){
    onsqlresult = RowImg
    sattelanalyse.send(`sql select * from recordings WHERE analysis=2 AND session_id=${localStorage.getItem('session').split(' ')[1]}`)
    }
    if(localStorage.getItem('session').split(' ')[0]=='start'){
     onsqlresult = getSession
     sattelanalyse.send(`sql SELECT next_id from nextids n WHERE table_name = 'sessions'`)
     let getrow = setInterval(function () {
      onsqlresult = RowImg
      sattelanalyse.send(`sql select * from recordings WHERE analysis=2 AND session_id=${localStorage.getItem('new_session')}`)
      clearInterval(getrow);
    }, 1000);
    }
    UIkit.modal($('#modal-center-load1')).show();
  
}
var sess;

/**
 * This function is called when the database returns a result from the query. It takes the result as a
 * parameter and sets the local storage variable 'new_session' to the next available session id
 * @param params - [{next_id: 1}]
 */
function getSession(params) {
    onsqlresult = getLog;
    // console.log(params);
    params.forEach(element => {
      // console.log(element.next_id-1);
      sess= element.next_id-1;
      console.log(sess);
      localStorage.setItem('new_session',element.next_id-1)
    });
  }

function getImgData(num,ele) {
    galerie_image_info = JSON.parse(gal[num])
    //console.log(galerie_image_info);
    console.log();
  
    let noselect = document.getElementsByClassName('flex-column-center')
    for (const iterator of noselect) {
      iterator.removeAttribute('style')
    }
    ele.firstChild.setAttribute('style','border: 1px solid var(--primary);padding: 0.5em')
  
     let btn = document.getElementById('img_select_btn');
     btn.setAttribute('onclick',`sattelanalyse.send('recording retrieve ${recID[num]} ${load_num}')`)
     btn.removeAttribute("disabled")

     sattelanalyse.send(`recording retrieve ${recID[num]} ${load_num}`)

     let chart_a = document.getElementById(`canvas${load_num}_3d`)
        //   chart_b = document.getElementById('canvas2_3d')
         chart_a.setAttribute('onclick',`OpenChart(${recID[num]})`)
        //   chart_b.setAttribute('onclick',`OpenChart(${recID[recID.length-1]})`)

    translatejs()
  }
  check_img_detail.addEventListener('change', function() {
    let detail = document.getElementsByClassName('detail')
    if (this.checked) {
      for (const iterator of detail) {
        iterator.classList.remove('hidden')
      }
    } else {
      for (const iterator of detail) {
        iterator.classList.add('hidden')
      }
    }
  });

function open_img(params) {
    UIkit.modal($('#modal-center-load'+params)).show();
}

function load(params,id) {
    sattelanalyse.send(`recording retrieve ${id} ${params}`)
    if(log){
        console.log('load',`recording retrieve ${id} ${params}`);
    }
}
var DelImg;
function openDelDialog(params) {
    DelImg = params
    OpenModDialog({type:'warn',title:["del_img_title"],msg:["del_img"],master_btn:['button_delete','del_img()'],slave_btn:['button_cancel']})
    //UIkit.modal($('#modal-mod_DelImg')).show();
}

function del_img() {
    sattelanalyse.send(`sql DELETE FROM recordings WHERE recording_id=${DelImg}`)
    if(log){
        console.log('del img',`sql DELETE FROM recordings WHERE recording_id=${DelImg}`);
    }
    location.reload();
}


function result_1(params) {
    if(log)
    console.log('result_1',params);
    document.getElementById('S1').innerHTML = params.product;
    document.getElementById('T1').innerHTML = params.product_label;
    document.getElementById('v1').innerHTML = params.front_rear;
    document.getElementById('l1').innerHTML = params.left_right;
    document.getElementById('V1').innerHTML = params.veloscore;
    if(params.pelvisrotation)
    document.getElementById('B1').innerHTML = `${params.pelvisrotation.center.x||""}x${params.pelvisrotation.center.y||""}`||"";
    document.getElementById('N1').innerHTML = params.notes;
}
function result_2(params) {
    if(log)
    console.log('result_2',params);
    document.getElementById('S2').innerHTML = params.product;
    document.getElementById('T2').innerHTML = params.product_label;
    document.getElementById('v2').innerHTML = params.front_rear;
    document.getElementById('l2').innerHTML = params.left_right;
    document.getElementById('V2').innerHTML = params.veloscore;
    if(params.pelvisrotation)
    document.getElementById('B2').innerHTML = `${params.pelvisrotation.center.x||""}x${params.pelvisrotation.center.y||""}`||"";
    document.getElementById('N2').innerHTML = params.notes;
}

function RowImg(params) {
    fi = 0;
    recID = [];
    onsqlresult = getLog;
    var append1 = document.getElementById('img_list2')//('img_gal')
    append1.innerHTML ="";
    params.forEach(element => {
            if(fi===0){
                sattelanalyse.send(`recording retrieve ${element.recording_id} 3`)
                fi++
            }
            recID.push(element.recording_id)
            let master = document.createElement('div');
            master.classList.add('imgGal2'); //hover
            master.id = `img_${element.recording_id}`
            append1.append(master);
  
              let div = document.createElement('div');
              div.classList.add('flex-column-center')
              div.id = `sel_${element.recording_id}`
              master.append(div);
  
              let date = document.createElement('p');
              date.classList.add('uk-text-center');
              date.innerHTML = element.finished;
              master.append(date)
  
              let div_name = document.createElement('div');
              div_name.classList.add('name_img');
              div.append(div_name)
  
              let img = document.createElement('img');
              img.width=100;
              img.height=100;
              img.classList.add('imgGal1');
              div.append(img);
  
              let div2 = document.createElement('div')
              div2.setAttribute('style','width: 150px')
              div.append(div2)
  
              let div_info = document.createElement('div');
              div_info.classList.add('uk-grid','uk-child-width-1-2','info_img','detail','hidden');
              let chk = document.getElementById('check_img_detail');
              if(chk.checked){
                div_info.classList.remove('hidden')
              }
              div_info.setAttribute('style','margin: 0 -30px;');
              div2.append(div_info);
    });
    chart_a = document.getElementById('canvas1_3d')
    chart_b = document.getElementById('canvas2_3d')
    chart_a.setAttribute('onclick',`OpenChart(${recID[0]})`)
    chart_b.setAttribute('onclick',`OpenChart(${recID[recID.length-1]})`)
  
  }


function selectImg(params) {
    let id = params.id.split('_')[1]
    if(chk1.value === "0"){
        if(params.classList.contains('selected')){
            return;
        }
        console.log(`${id} selected 1`);
        sattelanalyse.send(`recording retrieve ${id} 1`)
        chart_a.setAttribute('onclick',`OpenChart(${id})`)
        chk1.value = id
        params.classList.add('selected','mdi-checkbox-marked-circle-outline')
        params.classList.remove('unselect','mdi-checkbox-blank-circle-outline')
        return;
    }

    if(chk2.value === "0"){
        if(params.classList.contains('selected')){
            return;
        }
        console.log(`${id} selected 2`);
        sattelanalyse.send(`recording retrieve ${id} 2`)
        chart_b.setAttribute('onclick',`OpenChart(${id})`)
        chk2.value = id
        params.classList.add('selected','mdi-checkbox-marked-circle-outline')
        params.classList.remove('unselect','mdi-checkbox-blank-circle-outline')
        return;
    }

    if(chk1.value === id){
        console.log(`${id} deselected 1`);
        chk1.value = 0
        params.classList.add('unselect','mdi-checkbox-blank-circle-outline')
        params.classList.remove('selected','mdi-checkbox-marked-circle-outline')
        return;
    }
    if(chk2.value === id){
        console.log(`${id} deselected 2`);
        chk2.value = 0
        params.classList.add('unselect','mdi-checkbox-blank-circle-outline')
        params.classList.remove('selected','mdi-checkbox-marked-circle-outline')
        return;
    }
}

function generateData(dd) {
    console.log('dd',dd);
    var data = [];
    var kuenzel2 = dd
    for (var i = 0; i < 28; i++) {
      for (var j = 15; j >= 0; j--) { 
        if(Number(kuenzel2[i][j]) > max)
        max = kuenzel2[i][j]
        data.push([i,j,`${kuenzel2[i][j]}`]);
      }
    }
    return data;
  }

var SetMax=false;
var newMax=0
  function setMax(params) {
    SetMax = true
    newMax = params
  }

  var dom = document.getElementById('chart-container');
  var myChartX = echarts.init(dom, 'dark', {
    renderer: 'canvas',
    useDirtyRect: false
  });

function setChartType(params) {

    myChartX.setOption((option = {
        series: [
            {
                type: params,
                data:Cdata,
                symbolSize:15,
                shading: 'realistic', //color,lambert,realistic
                animation:false,
                label: {
                  fontSize: 16,
                  borderWidth: 1
                },
                emphasis: {
                  label: {
                    fontSize: 20,
                    color: '#00000000'
                  },
                  itemStyle: {
                    color: '#000000'
                  }
                }
            }
          ]
    }))
    
}
var Cdata;

function heatchart (data){
    let saddle = JSON.parse(recData[open_chartID])
    //console.log('Sattel',saddle);
    var dd = []
    data.forEach(element => {
        let d = element.pressure_values.split(' ')
        let tmp =[]
        for (let i = 0; i < d.length; i++) {
            tmp.push(d[i])
            if(tmp.length == 16){
                dd.push(tmp);
                tmp = [];
            }
        }
        // console.log(dd);
    });
    //var dom = document.getElementById('chart-container');
    //var myChartX = echarts.init(dom, 'dark', {
    //  renderer: 'canvas',
    //  useDirtyRect: false
    //});
    
    //inRange: {
    //    color: [
    //      '#00000000',
    //      '#0000ff',
    //      '#00ff00',
    //      '#ffff00',
    //      '#ff0000'
    //    ]
    //  }

    var option;
    var ColorRange = ['#00000000','#0000ff','#00ff00','#ffff00','#ff0000']
    //var ColorRange = ['#00000000','#00ff00', '#33cc33', '#66aa66', '#999999', '#cc6666', '#ff3333', '#ff0000'];

    //var ColorRange = ['#ff0000','#ffff00','#00000000','#00ff00','#0000ff',] //negative


    $.getScript(
      '/production/js/chart/simplex-noise.js'
    ).done(function () {
    //  max = 0;
      Cdata = generateData(dd);
      myChartX.setOption(
        (option = {
            backgroundColor: '#ffffffff',
          visualMap: {
            show: false, //true
            calculable: true,
            min: 0,
            max: max,
            inRange: {
                color: ColorRange,
            },
          },
          xAxis3D: {
            type: 'category',
          },
          yAxis3D: {
            type: 'category',
          },
          zAxis3D: {
            type: 'value',
            max: 0,
            min: max*2
          },
          toolbox: { 
            show: true, 
            orient: 'vertical', 
            itemsize: 16,
            iconStyle: {
                //color: '#000'
                borderColor: '#999',
                borderWidth: 1 ,
            },
            left:10,
            feature: {
                //magicType: {
                //    type: ["line3D", "bar3D","scatter3D","surface"]
                //}, 
                //dataZoom: { show: true }, 
                //dataView: { show: true },
                saveAsImage: { 
                    show: true, 
                    name: `${saddle.product||'NO_PRODUCT'}-${saddle.product_label||'NO_TYPE'}`, 
                    type: 'png',
                    pixelRatio:2 
                }
            } 
          },
          grid3D: {
                boxWidth: 28*10,
                boxDepth: 16*10,
            axisLine: {
              lineStyle: { color: '#99999900' }
            },
            axisPointer: {
              lineStyle: { color: '#99999900' }
            },
            viewControl: {
                distance:300,
                alpha:45,
                beta:270
            },
            //light: {
            //  main: {
            //    shadow: true,
            //    intensity: 1
            //  }
            //}
            light: {
                main: {
                  intensity: 1.2,
                  shadow: true,
                },
                ambient: {
                  intensity: 0.3,
                },
              },
          },
          series: [
            {
              type: 'bar3D',//line3D, bar3D,scatter3D,surface
              data: Cdata,
              shading: 'lambert', //color,lambert,realistic
              symbolSize(value) {
                // Customize the size of the data points based on the values
                return Math.abs(value[2]) + 10; // Use the absolute value of the Z coordinate
              },
            //  animation:false,
              label: {
                fontSize: 16,
                borderWidth: 1,
                show:false
              },
              emphasis: {
                label: {
                  fontSize: 20,
                  color: '#00000000',
                  show: true,
                },
                itemStyle: {
                    color: '#000000'
                }
              }
            }
          ]
        })
      );
    });
    
    if (option && typeof option === 'object') {
      myChartX.setOption(option);
    }
    
    window.addEventListener('resize', myChartX.resize);
}


var open_chartID;
function OpenChart(id) {
    open_chartID = id
    onsqlresult = heatchart
    sattelanalyse.send(`sql select pressure_values from recordings where recording_id = ${id}`)
    UIkit.modal('#chart_modal').show();
}


function PDFgenGal(){
    let name = localStorage.getItem('client_name').split(' ')

    var content = [
        {text: `${aLangKeys[lang]['pro_tab_galerie']} - ${name[1]} ${name[0]}`, style: 'header'},
        '\n',
        {canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]},
        '\n']

    let contentObj = {}
    let columns = []

    let tmp = {}
    for (const i of document.getElementsByClassName('imgGal1')) {
        // let canvasGal = new fabric.Canvas("canvas_3");
        // createCanvas(canvasGal)
        let image = i

        let toDataURL = () => {
            let canvas = document.createElement('canvas');
    
            // We use naturalWidth and naturalHeight to get the real image size vs the size at which the image is shown on the page
            canvas.width = image.naturalWidth;
            canvas.height = image.naturalHeight;
    
            // We get the 2d drawing context and draw the image in the top left
            canvas.getContext('2d').drawImage(image, 0, 0);
    
            // Convert canvas to DataURL and log to console
            let dataURL = canvas.toDataURL();
            // console.log(dataURL);
            // logs data:image/png;base64,wL2dvYWwgbW9yZ...
            let x = new Object();
            x.image = dataURL
            x.width=150
            columns.push(x)
            console.log(columns.length);
            if(columns.length%3==0){
                tmp.alignment = "justify"
                tmp.columns = columns
                content.push(tmp)
                content.push(`\n`)
                tmp={}
                columns=[]

            }

        };
        
        // If the image has already loaded, let's go!
        if (image.complete) toDataURL(image);
        // Wait for the image to load before converting
        else image.onload = toDataURL;

    }
    contentObj.alignment = "justify"
    contentObj.columns = columns
    console.log("A",content);
    content.push(contentObj)
    console.log("B",content);

    // console.log(content);
    var dd = {
        content,
            styles: {
                header: {
                    fontSize: 18,
                    bold: true
                },
                bigger: {
                    fontSize: 15,
                    italics: true
                },
                small:{
                    fontSize:10
                }
            },
            defaultStyle: {
                columnGap: 20
            }
            
        }
        pdfMake.createPdf(dd).open();
        
    }
        
var content=[]
var dd = {}

function PDFgen() {
    var content=[]
    var dd = {}
    let sk_text=""
    let sk = document.getElementById('sitzknochenabstand').value||"0"

    if(!script_setting.UserUnit || script_setting.UserUnit === "cm"){
        sk_text = `${sk} cm`
    }
    if(script_setting.UserUnit === "in"){
        sk_text = `${(sk/2.54).toFixed(2)} in`
    }
    
  var img1 = canvas1.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossOriginIsolated: false,
  });
  var img2 = canvas2.toDataURL({
    format: "png",
    quality: 100,
    width: cw,
    height: ch,
    crossOriginIsolated: false,
  });

  let name = localStorage.getItem('client_name').split(' ')
  let text = script_setting.UserEinleitung && script_setting.UserEinleitung !== "" ? script_setting.UserEinleitung : aLangKeys[lang]['pro_einleitung']

//DECKBLATT
  content.push({text:`${aLangKeys[lang]['pro_bikefit']}`,style:['header','bold','center']})
  content.push({text:`${aLangKeys[lang]['pro_head']}`,style:['header','bold','center']})
  content.push('\n')
  content.push({text:`${name[1]} ${name[0]}`, style: ['XXL','bold','center']})
  if(localStorage.getItem('session_note') !== ''){
    content.push({text:`${localStorage.getItem('session_note')}`, style: ['bigger','bold','center']})   
  }
  content.push({text:`${new Date().toISOString().split('T')[0]}`,style:['small','center']})
  content.push('\n')
    content.push({text:`${text}`})
    content.push('\n')
  if(script_setting.UserCompany){
    content.push({text:`${script_setting.UserCompany}`,style:['center','bigger','bold']})
  }
  if(script_setting.UserStreet || script_setting.UserCity){
    content.push('\n')
  }
  if(script_setting.UserStreet){
    content.push({text:`${script_setting.UserStreet}`,style:'center'})
  }
  if(script_setting.UserCity){
    content.push({text:`${script_setting.UserCity}`,style:'center'})
  }
  if(script_setting.UserMail || script_setting.UserWeb){
    content.push('\n')
  }
  if(script_setting.UserMail){
    content.push({text:`${script_setting.UserMail}`,style:'center'})
  }
  if(script_setting.UserWeb){
    content.push({text:`${script_setting.UserWeb}`,style:'center'})
    content.push('\n')
    content.push({ qr: `${script_setting.UserWeb}`,fit:50,style:'center' })
  }
  content.push({text:"",pageBreak: 'after'})
// // DECKBLATT
  if($('#check_anamnesis').is(':checked')){
  content.push({text:`${aLangKeys[lang]['pro_anamnese']}`,style:'bigger',pageNumbers:[1]})
  content.push('\n')
  content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ],pageNumbers:[1]})
  content.push('\n')
  content.push({
    alignment: 'justify',
    columns:[
        {
            text:   `${aLangKeys[lang]['pro_name_vorname']}\n
                     ${aLangKeys[lang]['pro_sitzknochenabstand']}\n
                     ${aLangKeys[lang]['pro_disbalance']}`
            ,style:  'small'
        },
        {
            text:   `${name[0]}, ${name[1]}\n
                     ${sk_text}\n
                     ${aLangKeys[lang]['pro_dis_'+document.getElementById('asymmetrie').value]}`
                     ,style:  'small'
        },
        {
            text:   `${aLangKeys[lang]['pro_einsatz']}\n
                     ${aLangKeys[lang]['pro_fahrgewohnheit']}\n
                     ${aLangKeys[lang]['pro_Sitzpos']}`
                     ,style:  'small'
        },
        {
            text:   `${aLangKeys[lang]['pro_einsatz_'+document.getElementById('einsatzbereich').value]}\n
                     ${aLangKeys[lang]['pro_fahrgewohnheit_'+document.getElementById('fahrleistung').value]}\n
                     ${aLangKeys[lang]['pro_Sitzpos_'+document.getElementById('sitzposition').value]}`
                     ,style:  'small'
        }
    ],pageNumbers:[2]
    })
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
  }
  if($('#check_sattelanalyse').is(':checked')){
    content.push({text:`${aLangKeys[lang]['pro_satteldruck']}`,style:'bigger'})
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
    content.push({
        alignment: 'justify',
        columns: [
            {
                image:img1,
                width: 100
            },
            {
              text:`${aLangKeys[lang]['pro_satteldruck_marke']}\n
                    ${aLangKeys[lang]['pro_satteldruck_typ']}\n
                    ${aLangKeys[lang]['pro_satteldruck_frontback']}\n
                    ${aLangKeys[lang]['pro_satteldruck_leftright']}\n
                    ${aLangKeys[lang]['pro_satteldruck_veloscore']}\n
                    ${aLangKeys[lang]['pro_satteldruck_becken']}\n
                    ${aLangKeys[lang]['pro_satteldruck_note']}\n`
                    ,style:'small'
            },
            {
              text:`${document.getElementById('S1').innerHTML}\n
                    ${document.getElementById('T1').innerHTML}\n
                    ${document.getElementById('v1').innerHTML}\n
                    ${document.getElementById('l1').innerHTML}\n
                    ${document.getElementById('V1').innerHTML}\n
                    ${document.getElementById('B1').innerHTML}\n
                    ${document.getElementById('N1').innerHTML}\n`
                    ,style:'small'
            }
        ]
    })
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
    content.push({
        alignment: 'justify',
        columns: [
          {
              image:img2,
              width: 100
          },
          {
            text:`${aLangKeys[lang]['pro_satteldruck_marke']}\n
                  ${aLangKeys[lang]['pro_satteldruck_typ']}\n
                  ${aLangKeys[lang]['pro_satteldruck_frontback']}\n
                  ${aLangKeys[lang]['pro_satteldruck_leftright']}\n
                  ${aLangKeys[lang]['pro_satteldruck_veloscore']}\n
                  ${aLangKeys[lang]['pro_satteldruck_becken']}\n
                  ${aLangKeys[lang]['pro_satteldruck_note']}\n`
                  ,style:'small'
          },
          {
            text:`${document.getElementById('S2').innerHTML}\n
                  ${document.getElementById('T2').innerHTML}\n
                  ${document.getElementById('v2').innerHTML}\n
                  ${document.getElementById('l2').innerHTML}\n
                  ${document.getElementById('V2').innerHTML}\n
                  ${document.getElementById('B2').innerHTML}\n
                  ${document.getElementById('N2').innerHTML}\n`
                  ,style:'small'
          }
      ]
    })
    content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    //content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
  }
  if($('#check_ergo').is(':checked')){
    content.push({text:`${aLangKeys[lang]['pro_ergodrei']}`,style:'bigger',pageBreak: 'before'})
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
    content.push({
        svg:`<svg id="eK7vFUDaQ2O1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 30000 30000" shape-rendering="geometricPrecision" text-rendering="geometricPrecision">
        <g>
            <g>
                <g>
                    <g>
                        <g>
                            <g>
                                <path d="M18358,8497l325,734" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="400" stroke-linejoin="round"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M18464,8691l696-401" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="400" stroke-linejoin="round"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M19433,8247c0,36-10,73-28,105s-45,58-77,77c-32,18-68,28-104,28-37,0-73-10-105-28-32-19-59-45-77-77s-28-69-28-105c0-37,10-74,28-106s45-58,77-77c32-18,68-28,105-28c36,0,72,10,104,28c32,19,59,45,77,77s28,69,28,106v0Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                <path d="M19433,8247c0,36-10,73-28,105s-45,58-77,77c-32,18-68,28-104,28-37,0-73-10-105-28-32-19-59-45-77-77s-28-69-28-105c0-37,10-74,28-106s45-58,77-77c32-18,68-28,105-28c36,0,72,10,104,28c32,19,59,45,77,77s28,69,28,106Z" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="100" stroke-linejoin="round"/>
                            </g>
                        </g>
                    </g>
                    <g>
                        <g>
                            <g>
                                <path d="M11081,10029l957,2788" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="400" stroke-linejoin="round"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M9994,9724l938,409l367-150-109-217-1196-42Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <g>
                                    <path d="M10070,9681c37,20,37,33,171,29c248-21,495-42,742-64c41-4,234-2,589-220-528,4-946,117-1502,255Zm1667-426c-83,6,148,195,64,201-244,117-377,321-732,352-276,24-551,46-826,70-112-6-206,19-442-266-28-15,1949-346,1936-357Z" fill-opacity="0.988" fill-rule="evenodd" stroke="#fff" stroke-width="28.222" stroke-opacity="0.988" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M10070,9680c-220-52-174-48-270-68-27-15-67-27-94-43-194-27-432-4-604-292-87-42-176-74-264-116c11-6-37-197,174-240c1271-29,2002,268,3280,221c470,3,327,262,323,249-102,4-202,9-304,13-36,65-148,45-222,68-13-12-26-23-39-35-83,7-166,13-249,20-558-66-1175,86-1731,223Z" fill="#50595f" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M9720,9566c-191,1-445,0-618-289-87-42-176-74-264-116c11-5-37-198,175-240-283,195,1010,511,707,645Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M10236,9636c-59,21-90,18-168,47-160-29-333-98-362-113-299-230-260-164-603-293-89-42-177-74-265-116c11-6-37-197,174-240-102,142,1134,384,1224,715Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M2947,15073c40-79,82-157,126-233c418-723,1018-1324,1741-1741s1543-637,2378-637s1655,220,2378,637s1323,1018,1741,1741c417,723,637,1543,637,2378c0,68-1,136-4,204" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M9012,13007c556,227,1051,560,1464,973s746,908,973,1464c227,551,352,1162,352,1811s-125,1260-352,1811c-227,556-560,1051-973,1464-413,414-908,745-1464,973-551,227-1162,352-1812,352-648,0-1259-125-1810-352-556-228-1051-559-1464-973-413-413-746-908-973-1464-227-551-352-1162-352-1811s125-1260,352-1811c227-556,560-1051,973-1464s908-746,1464-973c551-227,1162-352,1810-352c650,0,1261,125,1812,352Zm-380,7572c431-177,816-435,1136-756c322-321,580-705,757-1137c179-435,276-919,276-1431s-97-996-276-1431c-177-431-435-816-757-1136-320-322-705-580-1136-757-435-179-919-276-1432-276-511,0-995,97-1430,276-431,177-816,435-1136,757-322,320-580,705-757,1136-179,435-276,919-276,1431s97,996,276,1431c177,432,435,816,757,1137c320,321,705,579,1136,756c435,179,919,276,1430,276c513,0,997-97,1432-276Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M6883,20160c1431-766,2863-1531,4294-2297c513,148,1038,213,1551,361c710,96,1275-1420,0-1612-2125,39-4249,33-6374,73c369,585,738,1172,1107,1755-337,406-674,810-1011,1215c144,168,290,337,433,505Z" transform="translate(.000001 0)" fill="none" fill-rule="evenodd" stroke="#50595f" stroke-width="100" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M8496,17286c0,237-62,469-181,674-118,205-288,375-493,493-205,119-437,181-673,181-237,0-469-62-674-181-205-118-375-288-493-493-119-205-181-437-181-674c0-236,62-468,181-673c118-205,288-375,493-493c205-119,437-181,673-181c237,0,469,62,674,181c205,118,375,288,493,493c119,205,181,437,181,673v0Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M10453,17431l2368,12" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="500" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M13798,12679l-68-148l1377-632l136,296-1377,633-68-149Z" fill="#50595f" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M12378,12886l389-178l138,60l1066-485l124,30l171,373-56,117v0l-1065,488-45,145-389,178-333-728Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M15371,12021c-28,306-973-120-2387,464l1755-912c0,0,721,222,632,448Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M12886,13144c0,86-65,150-150,150h-1l-290,150-48-154l191-125c0-7,0-14,0-21c0-59,30-108,77-132l-27-259l107-86l106,380c22,25,35,59,35,97Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M24613,13008c556,227,1051,560,1464,973s746,908,973,1464c227,551,352,1162,352,1811s-125,1260-352,1811c-227,556-560,1051-973,1464-413,414-908,745-1464,973-551,227-1162,352-1812,352-648,0-1259-125-1810-352-556-228-1051-559-1464-973-413-413-746-908-973-1464-227-551-352-1162-352-1811s125-1260,352-1811c227-556,560-1051,973-1464s908-746,1464-973c551-227,1162-352,1810-352c650,0,1261,125,1812,352Zm-380,7572c431-177,816-435,1136-756c322-321,580-705,757-1137c179-435,276-919,276-1431s-97-996-276-1431c-177-431-435-816-757-1136-320-322-705-580-1136-757-435-179-919-276-1432-276-511,0-995,97-1430,276-431,177-816,435-1136,757-322,320-580,705-757,1136-179,435-276,919-276,1431s97,996,276,1431c177,432,435,816,757,1137c320,321,705,579,1136,756c435,179,919,276,1430,276c513,0,997-97,1432-276Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M6984,17396l5706-4989l6049-2798l245,454-6218,7315-5197,339-477-416" fill="none" fill-rule="evenodd" stroke="#5cbc40" stroke-width="550" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M11609,11587l1670,5129" fill="none" fill-rule="evenodd" stroke="#5cbc40" stroke-width="550" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M18671,9227l631,1486" fill="none" fill-rule="evenodd" stroke="#5cbc40" stroke-width="550" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M19608,11120l2890,6370" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="800" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M12858,13148c0,21-6,42-16,60-11,18-26,33-44,44-18,10-39,16-60,16s-42-6-60-16c-18-11-33-26-44-44-10-18-16-39-16-60s6-42,16-60c11-18,26-33,44-44c18-10,39-16,60-16s42,6,60,16c18,11,33,26,44,44c10,18,16,39,16,60v0Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M15325,11990c0,19-5,37-14,53-10,16-23,29-39,39-16,9-34,14-53,14s-37-5-53-14c-16-10-29-23-39-39-9-16-14-34-14-53s5-37,14-53c10-16,23-29,39-39c16-9,34-14,53-14s37,5,53,14c16,10,29,23,39,39c9,16,14,34,14,53v0Z" fill="#50595f" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M22997,17582c0,34-9,68-26,97s-42,54-71,71c-30,17-63,26-97,26-35,0-68-9-98-26-29-17-54-42-71-71s-26-63-26-97s9-68,26-97s42-54,71-71c30-17,63-26,98-26c34,0,67,9,97,26c29,17,54,42,71,71s26,63,26,97v0Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M7135,19793c0,67-18,132-51,190-33,57-81,105-138,138-58,33-123,51-190,51s-132-18-189-51c-58-33-106-81-139-138-33-58-51-123-51-190s18-132,51-189c33-58,81-106,139-139c57-33,122-51,189-51s132,18,190,51c57,33,105,81,138,139c33,57,51,122,51,189v0Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M7301,18721c0,54-14,106-41,153-27,46-65,84-112,111-46,27-99,41-152,41-54,0-107-14-153-41-47-27-85-65-112-111-27-47-41-99-41-153s14-106,41-152c27-47,65-85,112-112c46-27,99-41,153-41c53,0,106,14,152,41c47,27,85,65,112,112c27,46,41,98,41,152v0Z" fill="#383e42" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M7112,17358c-126,117-517,589-614,710c133,132,868,614,975,710-121,167-616,850-698,973" fill="none" fill-rule="evenodd" stroke="#50595f" stroke-width="300" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M13541,17438c0,138-37,275-106,395s-169,220-289,289-257,106-395,106c-139,0-276-37-396-106s-220-169-289-289-106-257-106-395c0-139,37-276,106-396s169-220,289-289s257-106,396-106c138,0,275,37,395,106s220,169,289,289s106,257,106,396Z" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="200" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M12753,17431l2368,12" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="500" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M19045,10818l520-216l409,355-722,346-207-485Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M18137,18357c-100-385-150-781-150-1178c0-831,220-1647,637-2366c417-720,1018-1317,1741-1733c723-415,1543-634,2378-634c750,0,1490,177,2159,516" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M22723,17147l2013-4227" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="53" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M22089,17377l-4055,345" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="53" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M6929,17157L3885,13811" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="53" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M7565,12518l-632,4643" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="53" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M3152,14594l661-735-588,103-73,632Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M3142,13950l-59,647" fill="none" fill-rule="evenodd" stroke="#e72b2c" stroke-width="159" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M19543,10748l264-337" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="81" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M19716,10485l530-24l43-681-308,80-265,625Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                        </g>
                    </g>
                    <g>
                        <text dx="0" dy="0" font-family="&quot;eK7vFUDaQ2O1:::Roboto&quot;" font-size="1500" font-weight="400" transform="matrix(.191922-.225202 0.225202 0.191922 16527.067483 13198.179951)" stroke-width="0">
                            <tspan y="0" font-weight="400" stroke-width="0">
                                <![CDATA[
    Velometrik
    ]]>
                            </tspan>
                        </text>
                        <g>
                            <path d="M15000,30169h-15258v-30339h30516v30339h-15258Z" fill="#fff" fill-opacity="0.561" fill-rule="evenodd" stroke="#fff" stroke-width="28.222" stroke-opacity="0.561" stroke-linejoin="round"/>
                        </g>
                    </g>
                </g>
            </g>
        </g>
        <g>
            <g>
                <g>
                    <g>
                        <g>
                            <g>
                                <g>
                                    <path d="M10182,6614l8283-925" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M9670,6671l555,119-39-357-516,238Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M18976,5631l-555-118l40,357l515-239Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M9900,8726L9648,6473" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M19206,7686l-252-2253" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M10391,17727L7851,10215" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M10556,18215l-3-568-340,115l343,453Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M7686,9728l2,567l340-115-342-452Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M12687,17494l-2321,785" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M9817,9007L7496,9792" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g transform="translate(0 10)">
                                <g>
                                    <path d="M20833,9692l-5949,8637" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M21125,9268l-453,341l295,204l158-545Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M14592,18753l453-342-295-204-158,546Z" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M19275,7994l2015,1387" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12742,17479l2015,1387" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M9876,8982l10000,1" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M15262,6190c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M15262,6190c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M9447,12555c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M9447,12555c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M18318,14486c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M18318,14486c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M9874,8983l9939-1110" fill="none" fill-rule="evenodd" stroke="#000" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M17982,8294c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M17982,8294c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M19394,7934c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z" fill="#f29400" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M10069,8994c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z" fill="#f29400" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M12913,17453c0,26-7,52-20,75s-32,42-55,55-49,20-75,20c-27,0-53-7-76-20s-42-32-55-55-20-49-20-75c0-27,7-53,20-76s32-42,55-55s49-20,76-20c26,0,52,7,75,20s42,32,55,55s20,49,20,76v0Z" fill="#f29400" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <g opacity="0.298039">
                                        <path d="M12733,21764l-33-16969" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <g opacity="0.298039">
                                        <path d="M3267,9325l19126,1" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M18035,9324h-4784" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M18550,9324l-538-179v359l538-180Z" fill="#f00" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M12736,9324l539,180v-359l-539,179Z" fill="#f00" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M18550,9148v376" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12736,9148v376" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M12733,16931v-7086" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12733,17446l180-538h-359l179,538Z" fill="#f00" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M12733,9330l-179,539h359l-180-539Z" fill="#f00" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M12916,17446h-383" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M12916,9330h-383" fill="none" fill-rule="evenodd" stroke="#f00" stroke-width="106" stroke-linecap="round" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M15673,9499c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M15673,9499c0,136-36,269-103,386-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-386c0-135,36-268,103-385c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,385Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                            <g>
                                <g>
                                    <path d="M13576,11622c0,135-36,268-103,385-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-385c0-136,36-269,103-386c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,386v0Z" fill="#5cbc40" fill-rule="evenodd" stroke-width="28.222" stroke-linejoin="round"/>
                                    <path d="M13576,11622c0,135-36,268-103,385-68,117-166,214-283,282-117,67-250,103-386,103s-269-36-386-103c-117-68-215-165-283-282-67-117-103-250-103-385c0-136,36-269,103-386c68-117,166-214,283-282c117-67,250-103,386-103s269,36,386,103c117,68,215,165,283,282c67,117,103,250,103,386Z" fill="none" fill-rule="evenodd" stroke="#fff" stroke-width="212" stroke-linejoin="round"/>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </g>
        </g>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 8466.412568 12807.569367)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    B
    ]]>
            </tspan>
        </text>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 16934.441743 8541.552185)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    D
    ]]>
            </tspan>
        </text>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 14214.441742 6437.552185)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    A
    ]]>
            </tspan>
        </text>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 14630.192749 9746.552185)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    E
    ]]>
            </tspan>
        </text>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 12591.931931 11873.569367)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    F
    ]]>
            </tspan>
        </text>
        <text dx="0" dy="0" font-family="&quot;Ruda Bold&quot;" font-size="1500" font-weight="400" transform="matrix(.5 0 0 0.5 17295.821122 14738.569367)" fill="#fff" stroke-width="0">
            <tspan y="0" font-weight="400" stroke-width="0">
                <![CDATA[
    C
    ]]>
            </tspan>
        </text>
        <style>
            <![CDATA[
    @font-face {font-family: 'eK7vFUDaQ2O1:::Roboto';font-style: normal;font-weight: 400;src: url(data:font/ttf;charset=utf-8;base64,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) format('truetype');}
    ]]>
        </style>
    </svg>`,
       width: 500
    })
    content.push({
        alignment:'justify',
        columns:[
            {
                text:   `${aLangKeys[lang]['pro_A']}: ${document.getElementById('pro_a').value||'-'} cm\n
                         ${aLangKeys[lang]['pro_B']}: ${document.getElementById('pro_b').value||'-'} cm\n
                         ${aLangKeys[lang]['pro_C']}: ${document.getElementById('pro_c').value||'-'} cm`
            },
            {
              text:     `${aLangKeys[lang]['pro_D']}: ${document.getElementById('pro_d').value||'-'} °\n
                         ${aLangKeys[lang]['pro_E']}: ${document.getElementById('pro_e').value||'-'} cm\n
                         ${aLangKeys[lang]['pro_F']}: ${document.getElementById('pro_f').value||'-'} cm`
            }
        ]
    })
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
  }
  if($('#check_note').is(':checked') && document.getElementById('pro_note').value !== ""){
    content.push({text:"",pageBreak: 'after'})
    content.push({text:`${aLangKeys[lang]['pro_note']}`,style:'bigger'})
    content.push('\n')
    content.push({canvas: [ { type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]})
    content.push('\n')
    content.push({text:`${document.getElementById('pro_note').value||''}`})
  }
  console.log(content);
    dd = {
        // a string or { width: number, height: number }
        pageSize: 'LETTER',
        // by default we use portrait, you can change it to landscape if you wish
        pageOrientation: 'portrait',
        // [left, top, right, bottom] or [horizontal, vertical] or just a number for equal margins
        pageMargins: [ 40, 90, 40, 50 ],
        // watermark: { text: 'Velometrik Gmbh', fontSize: 20 },
        styles: {
            header: {
                fontSize: 18
            },
            center:{
                alignment: 'center'
            },
            left:{
                alignment: 'left'
            },
            right:{
                alignment: 'right'
            },
            XXL:{
                fontSize:48
            },
            bold:{
                bold: true
            },
            bigger: {
                fontSize: 15,
                italics: true
            },
            small:{
                fontSize:10
            },
            XXS:{
                fontSize:7
            }
        },
        defaultStyle: {
            columnGap: 20
        },
        info: {
            title: `${aLangKeys[lang]['pro_head']} - ${name[1]} ${name[0]}.pdf`,
            filename:`${aLangKeys[lang]['pro_head']} - ${name[1]} ${name[0]}.pdf`,
        },

        images: {
            Velologo: {
              url: `${location.origin}/production/images/Logo-mit-Schriftzug.png`,
            }
          },

        //background: function(currentPage, pageSize) {
        //    return `page ${currentPage} with size ${pageSize.width} x ${pageSize.height}`
        //  },

        header(currentPage, pageCount, pageSize) {
          // computations...
          let company = "";
          let street = "";
          let city = "";
          let phone= "";
          let mail="";
          let web="";
          let name2="";

          if(script_setting.UserCompany){
              company = script_setting.UserCompany
          }
          if(script_setting.UserStreet){
              street = script_setting.UserStreet
          }
          if(script_setting.UserCity){
              city = script_setting.UserCity
          }
          if(script_setting.UserPhone){
              phone = script_setting.UserPhone
          }
          if(script_setting.UserMail){
              mail = script_setting.UserMail
          }
          if(script_setting.UserWeb){
              web = script_setting.UserWeb
          }
          if(script_setting.UserName){
              name2 = script_setting.UserName
          }

          if(currentPage === 1){
              return
          }
          return [
              { text:"\n"},
              { text: `${company}`, style:['right','bigger'], margin:[40,0]/* extra style attributes */},
              { text:`${street} | ${city} | ${phone}`,style:['right','XXS'],margin:[40,0]},
              { text:`${mail} | ${web}`,style:['right','XXS'],margin:[40,0]},
            //  { text:"",style:['right'],margin:[40,0]},
              { text:`Bike Fitter: ${name2}`,style:['right','XXS'],margin:[40,0]},
              { text:`${name[1]} ${name[0]}`,style:['left','bigger','bold'],margin:[40,0]},
              { text:`${aLangKeys[lang]['pro_bikefit']} ${aLangKeys[lang]['pro_head']} ${new Date().toISOString().split('T')[0]}`,style:['left','XXS'],margin:[40,0]}
              
            //  {canvas: [ { type: 'line', x1: 40, y1: 0, x2: 515, y2: 0, lineWidth: 1 } ]}
            //  { text:`${new Date().toISOString().split('T')[0]}`,style:['small','left'],margin:[40,0]}
            ]
            //content.push({text:`${aLangKeys[lang]['pro_bikefit']}`,style:['header','bold','center']})
            //content.push({text:`${aLangKeys[lang]['pro_head']}`,style:['header','bold','center']})
        },

        background(currentPage, pageSize) {
            return [
                {image: 'Velologo',style:['left'],width:150,margin:[40,pageSize.height - 60]},
            ]
        },

        footer(currentPage, pageCount, pageSize) {
            return [
                {text: `Velometrik GmbH`,style: ['bigger','bold','right'],margin:[40,0]},
                {text:`Breunsdorfer Str. 48a | 04575 Neukieritzsch | Germany | info@velometrik.de | www.velometrik.com`,style:['XXS','right'],margin:[40,0]},
                {text: `\n${currentPage}/${pageCount}`,style:['XXS','center'],margin:[40,0]}
            ]    
        },

        //watermark: { text: 'unlicensed', color: 'blue', opacity: 0.3, bold: true, italics: false },

        content: content
        
    }
    //pdfMake.createPdf(dd).open();
    pdfMake.createPdf(dd).download(`${aLangKeys[lang]['pro_head']} - ${name[1]} ${name[0]}.pdf`);
}

function OpenMail(){
    //window.location.href = "mailto:mail@example.org";
    PDFgen()

    let user_company = "";
    let user_name = ""

    if(script_setting.UserCompany){
        user_company = script_setting.UserCompany
    }

    if(script_setting.UserName){
        user_name = script_setting.UserName
    }

    var recipient = localStorage.getItem('client_mail');
    var subject = `${aLangKeys[lang]['pro_head']} ${localStorage.getItem('client_name')}`;
    var body = `${aLangKeys[lang]['send_mail_protokoll_1']}${aLangKeys[lang]['send_mail_protokoll_2']}${user_company}\n${user_name}`;
  
    var mailtoLink = `mailto:${recipient}?subject=${encodeURIComponent(subject)}&body=${encodeURIComponent(body)}`;
  
    window.open(mailtoLink);

}
//var httpURL = new XMLHttpRequest();
var myWebServiceUrl = "/production/protokoll.tcls";
