#!/bin/bash
#
# .../setup/activate.sh
#
# Velometrik GmbH
#
# Installationsskript für vmkstationd
# Dieses Skript aktiviert eine neue Softwareversion, auf die der Link "vmkstationd_next" gelegt wurde
# mit folgenden Schritten:
# 1. Die aktuelle Version erhält den Link "vmkstationd_last".
# 2. Die  neue Softwareversion erhät den Link "vmkstation"
# 3. Der Link "vmkstationd_next" wird gelöscht.
#
# Author: Siegmar Müller
# Historie:
#   28.10.2019  Begonnen
#   30.10.2019  Version zum Testen fertiggestellt
#   22.11.2019  Fertiggestellt
#

if [ -z "$LOGFILE" ]; then
    LOGFILE=/var/local/log/vmkupdate.log
else
    echo -e "\n-------------------------------------------------------------------------------" | tee -a $LOGFILE
fi
# Die zu aktivierende Version muß mit next_dir oder last_dir verlinkt sein
# und activate.sh muß darüber aufgerufen werden.
NEWDIR=`echo \`realpath $0\` | sed 's?/setup/[a-z]*\.sh??'`
echo "activate.sh für $NEWDIR `date '+%d.%m.%Y %H:%M:%S'`" | tee -a $LOGFILE
NEWPATH=`echo \`realpath -s $0\` | sed 's?/setup/activate.sh??'`
echo $NEWPATH | grep -E -q '/vmkstationd_next|/vmkstationd_last'
if [ $? -ne 0 ]; then
    echo "FEHLER: Aufruf muß über vmkstationd_next oder vmkstationd_last gehen." | tee -a $LOGFILE
    exit 1
fi
if [ -L /usr/local/vmkstationd ]; then # Alte Version existiert
    OLDDIR=`realpath /usr/local/vmkstationd`
    if [ $OLDDIR == $NEWDIR ]; then
        echo "WARNUNG: $NEWDIR ist bereits aktiviert." | tee -a $LOGFILE
        rm -v $NEWPATH 2>&1 | tee -a $LOGFILE
        test ${PIPESTATUS[0]} -ne 0 && exit 1
        echo "$NEWPATH gelöscht"| tee -a $LOGFILE
        exit 0
    else
        # /usr/local/vmkstationd wird vmkstationd_last, was vmkstationsd.tcl nach seinem Start löscht.
        rm -f -v /usr/local/vmkstationd_last 2>&1 | tee -a $LOGFILE
        mv -v /usr/local/vmkstationd /usr/local/vmkstationd_last 2>&1 | tee -a $LOGFILE
        test ${PIPESTATUS[0]} -ne 0 && exit 1
        echo "$OLDDIR ist jetzt /usr/local/vmkstationd" | tee -a $LOGFILE
    fi
fi
# Diese Version als /usr/local/vmkstationd verlinken
# Dazu muß zunächst der alte Link entfernt werden.
if [ -f /usr/local/vmkstationd  -o -d /usr/local/vmkstationd ]; then # Alte Version ist kein Link
    # ..._last wurde nicht erzeugt
    echo "WARNUNG: Die alte Version war nicht verlinkt und kann deshalb nicht zurückgeholt werden."
fi
rm -rf -v /usr/local/vmkstationd 2>&1 | tee -a $LOGFILE
ln -s -v $NEWDIR /usr/local/vmkstationd 2>&1 | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1
rm -v /usr/local/vmkstationd_next 2>&1 | tee -a $LOGFILE
test ${PIPESTATUS[0]} -ne 0 && exit 1
echo "$NEWDIR aktiviert." | tee -a $LOGFILE

