# HTTP-Domäne /vmkservice

namespace eval vmkservice {

    variable ws_url ""

    ::http::register https 443 ::tls::socket

    # Angekommene Daten zurückgeben
    proc dataArrived {clientsocket token} {
        upvar #0 clientcontext$clientsocket context
        upvar #0 $token state

        srvLog vmkservice_$clientsocket Info "$context(url) -> $state(status)"
        if {$state(status) != "ok"} {
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$context(url) konnte nicht geholt werden."]
	        append html [::html::end]
            #TODO Fehlerstatus
        } else {
            set html $state(body)
            array set header $state(meta)
            if {[info exists header(Content-Type)]} {
                # Content-Type in den Header übernehmen
                set context(contenttype) $header(Content-Type)
            }
            ::http::cleanup $token
        }
        ::WSServer::finishDomainResponse $clientsocket $html
        #TODO REQUESTLOGLEVEL ?
		srvLog $clientsocket Info "Done %d Bytes" [string length $html]
    }

    # Requestbehandlung
    proc handleClientRequest {clientsocket {query {}} } {
        upvar #0 clientcontext$clientsocket context
        variable ws_url

        # Der Stationsserver wurde ursprünglich über der Referer ermittelt, was nicht zuverlässig funktionierte.
        # Jetzt wird der Name des Portalservers vom Webservice geliefert.
        if {"$::WS_URL" != ""} {
            set ws_url "${::WS_URL}"
            if {[string index $ws_url end] != "/"} {
                append ws_url "/"
            }
        }
        if {"$ws_url" == ""} {; #{{{ Fehlerseite zurückgeben
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "Diese Seite sollte nie zu sehen sein."]
            append html "(WS_URL nicht konfiguriert.)<BR/>"
	        append html [::html::end]
	        return $html
            #}}}
        }; # if ws_url unbekannt
        # Weiterleitung an den Webservice
        if {"$context(url)" == "/vmkservice"} {
            append context(url) "/"
        }
        set url [regsub {^.*vmkservice/} $context(url) $ws_url]
        srvLog vmkservice_$clientsocket Info "geturl $url from $ws_url"
        if {[catch {
            set token [::http::geturl $url -command "[namespace current]::dataArrived $clientsocket"]
            set context(self_finish) 1
            set html ""
        } errmsg]} {
            srvLog $clientsocket Error "$url -> $errmsg"
	        set html "<!doctype html>\n"
	        append html [::html::head "Velometrik GmbH: Lokaler HTTPS-Proxy"]
	        append html "<meta http-equiv=\"Content-Type\" content=\"text/html\" charset=\"UTF-8\"/>\n"
	        append html [::html::bodyTag]
	        append html [::html::h3 "$url konnte nicht geholt werden."]
            append html $errmsg
	        append html [::html::end]
            #TODO Fehlerstatus ?
        }
	    return $html
    }; # proc handleClientRequest 

}; # namespace eval vmkservice 

