#
# custom/kernel/normhocker.tcl
#
# Generierung von normierten Hockerbildern
#

namespace eval NormHocker {
    # Die Callbacks für die Fertigmeldungen.
    # Schlüssel ist der Imagetyp, Wert ist eine Liste der zugehörigen Handler.
    variable norm_handlers [dict create]

    #TODO Implementieren analog custom/kernel/normsattel.tcl


    # Weiteren Handler hinzufügen
    # Der Handler muß die Parameter
    #   imagetype druckbild n_rows n_cols
    # entgegennehmen.
    # @param cb_norm_handler   Name der Callbackprozedur
    # @param normtypes         Liste der Bildtypen, die der Handler bedient
    proc addNormHandler {cb_norm_handler normtypes} {; #{{{
        variable norm_handlers

        if {[llength $normtypes] == 0} {
            srvLog [namespace current] Error "::addNormHandler: must provide at least 1 normtype"
            return
        }
        # Vorsichtshalber prüfen, ob es den schon gibt
        foreach {normtype} $normtypes {
            if {[dict exists $norm_handlers $normtype]} {; # Es gibt Handler für $normtype, ...
                if {[lsearch [dict get $norm_handlers $normtype] $cb_norm_handler] < 0} {
                    # ... aber nicht diesen.
                    dict lappend norm_handlers $normtype $cb_norm_handler
                    srvLog [namespace current]::addNormHandler Debug "$cb_norm_handler added for $normtype"
                } else {
                    srvLog [namespace current]::addNormHandler Debug "$cb_norm_handler already added for $normtype"
                }
            } else {
                dict set norm_handlers $normtype $cb_norm_handler
                srvLog [namespace current]::addNormHandler Debug "$cb_norm_handler added for $normtype"
            }
        }
        #}}}
    }; # proc addNormHandler 


    # Handler entfernen
    proc removeNormHandler {cb_norm_handler} {; #{{{
        variable norm_handlers

        set not_found 1
        dict for {normtype handlers} $norm_handlers {; # Bildtypen durchgehen
            set i [lsearch [dict get $norm_handlers $normtype] $cb_norm_handler]
            if {$i >=0} {
                set new_handlers [lreplace [dict get $norm_handlers $normtype] $i $i]
                if {[llength $new_handlers] == 0} {; # kein Handler mehr für diesen Bildtyp
                    dict unset norm_handlers $normtype
                } else {
                    dict set norm_handlers $normtype $new_handlers
                }
                srvLog [namespace current]::removeNormHandler Debug "$cb_norm_handler removed for $normtype"
                set not_found 0
            }
        }; # Bildtypen durchgehen
        if {$not_found} {
            srvLog [namespace current]::removeNormHandler Warn "$cb_norm_handler not found"
        }
        #}}}
    }; # proc removeImageHandler 


    # Druckbild an die registierten Handler übergeben
    # (Callback für die Normierung)
    # @param imagetype  Bildtyp
    # @param n_rows     Anzahl Zeilen
    # @param n_cols     Anzahl Spalten
    proc normFinished {imagetype n_rows n_cols} {; #{{{
        variable norm_handlers 

        # Bild aus tsv holen und verteilen
        set  druckbild [::tsv::get normimages $imagetype]
        if {[dict exists $norm_handlers $imagetype]} {; # Es gibt Handler für $imagetype
            # Handler durchgehen
            foreach norm_handler [dict get $norm_handlers $imagetype] {
                $norm_handler $imagetype $druckbild $n_rows $n_cols
            }
        }
        #}}}
    }; #proc normFinished 


    # Normierte Druckdaten erzeugen
    # Die erzeugten Druckdaten werden von normFinished entgegengenommen
    # @param imagetype          Bildtyp
    # @param druckbild          Druckdaten
    # @param n_rows             Anzahl Zeilen
    # @param n_cols             Anzahl Spalten
    # (Abweichende Normierungsoptionen werden (noch) nicht gebraucht.
    #  Falls sie notwendig werden sollen: Ergänzen wie in custom/kernel/normsattel.tcl proc createNorm.)
    proc createNorm {imagetype druckbild n_rows n_cols} {; #{{{

        ::DBLD2NORM::startNorm [namespace current]::normFinished $druckbild $n_rows $n_cols $imagetype

        #}}}
    }


    # Modul-Initialisierung
    proc init {} {
        # Bislang nichts zu tun.
    }

}; # namespace eval NormHocker 

set mod_loaded NormHocker 

