# .../lib/kernel/signals.tcl
#
# Kernelmodul für die Ausgabe von (abstrakten) Signalen
# an die konkrete Hardware der Velobox
#

# Historie:
# 09.12.2023 Siegmar Müller Erstellt
#

namespace eval signals {

    variable LEDFARBEN [dict create SCHWARZ 0 GRUEN 1 BLAU 2 HELLBLAU 3 ROT 4 GELBGRUEN 5 VIOLETT 6 WEISS 7]
    variable STATUSFARBEN [dict create OFF SCHWARZ POWER ROT MATTE VIOLETT LAN BLAU INET HELLBLAU WEBSERVICE GRUEN LOGGED_IN WEISS]
    variable STATUSFARBEN [dict create OFF SCHWARZ POWER ROT LAN VIOLETT INET BLAU WEBSERVICE WEISS LOGGED_IN GRUEN]

    # Tonfolge am Piepser ausgeben
    # @param sound  Art des Klangs (vorerst bedeutungslos)
    proc playSound {sound} {; ##{{{
        # Wir kennen bislang nur einen Klang.
        if {$::PIEPSER} {
            # Ein Fehler an dieser Stelle ist unproblematisch,
            # darf aber den weiteren Ablauf nicht blockieren.
            catch {::piepser::toogleGpioValue $::piepser::BUZZER {100 100 800 2000}}
        }
        #}}}
    }; # proc playSound 


    # Schaltet die LED der Piepserplatine auf die angegebene Farbe
    # @param color  Farbe (Name aus LEDFARBEN)
    proc setLEDColor {color} {; #{{{
        variable LEDFARBEN

        if {$::PIEPSER} {
            ::piepser::setLED [dict get $LEDFARBEN $color]
        }
        #}}}
    }; # proc setLEDColor 


    # Signal ausgeben
    # Signaltypen:
    #   READY   Fertigmeldung => Piepton
    #   STATUS  Statuslevel, value: status (s. STATUSFARBEN)
    # @param sigtype    Signaltyp
    # @param value      Wert, falls erforderlich
    proc put {sigtype {value 0}} {; #{{{
        variable STATUSFARBEN

        switch $sigtype {
            "READY" {playSound READY}
            "STATUS" {
                if {[dict exists $STATUSFARBEN $value]} {
                    setLEDColor [dict get $STATUSFARBEN $value]
                } else {
                    srvLog [namespace current]::put Warn "Unknown status '$value' ignored."
                }
            }
            default {srvLog [namespace current]::put Warn "Unknown signal '$sigtype' ignored."}
        }
        #}}}
    }; # proc put


    # Modul initialisieren
    # (Dummy)
    proc init {} {; #{{{
        return ""
        #}}}
    }; # proc init 

}; # namespace eval signals 

set mod_loaded signals

