# Webservicedomäne /messages
#
# Verteilt den Apps übergeordnete Meldungen
#

# Historie:
# 13.12.2023 Siegmar Müller Verteilung des Stationsstatus
#

namespace eval messages {
    # Variablen für diese Domäne
    # variable ...

    # Es gibt einen neuen Stationsstatus
    # @param new_sstatus    Der neue Status (Liste aus Statusname und Statuslevel)
    proc setSStatus {new_sstatus} {
        ::WSServer::disposeServerMessage messages text "{\"wsevent\": \"vlbstat\", \"status\": \"[lindex $new_sstatus 0]\", \"level\": \"[lindex $new_sstatus end]\"}"
    }; # proc setSStatus 



    # Mitteilung vom Client verarbeiten
       # Hinweis: Das ist ein Callback, das mit ::websocket::live übergeben wird.
       # Es wird von ::websocket aufgerufen und befindet sich deshalb in einem
       # anderen namespace Kontext.
       # Prozeduren aus ::WSServer müssen deshalb mit vollem Namespacepfad
       # aufgerufen werden.
    proc handleClientMessage {clientsocket type msg} {; #{{{
	    upvar #0 clientcontext$clientsocket context
           # variable ...
	
	    # type laut API:
	    #   text        Complete text message
	    #   binary      Complete binary message
	    #   ping        Incoming ping message
	    #   connect     Notification of successful connection to server
	    #   disconnect  Disconnection from remote end
	    #   close       Pending closure of connection
	
	    switch -glob -nocase -- $type {
	        connect {
	            srvLog $clientsocket Info "Client connected"
                # Aktuellen Status an neuen Client senden
                # Dabei handelt es sich um die angeschlossenen Matten.
                # Callback setzen
                after 1000 "
                    # Das bewirkt eine sofortige Statusmeldung, die erst verzögert verteilt werden kann.
                    ::kernel::addStatusHandler [namespace current]::setSStatus
                "
	        }
	        text {
	            srvLog $clientsocket Notice "text message received:\n'$msg'"
	        }
	        binary {
	            srvLog $clientsocket Info "binary message received"
	        }
	        ping -
	        pong {
	            srvLog $clientsocket Debug "Client $type received"
                   # Kein Handlungsbedarf
	        }
	        close {
				srvLog $clientsocket Info "WS-Connection closing (%s)" $context(ipaddr)
                   # Kein Handlungsbedarf
	        }
	        disconnect {
				srvLog $clientsocket Info "WS-Connection disconnected (%s)" $context(ipaddr)
                # Callback zurücknehmen
                if {[catch {::kernel::removeStatusHandler [namespace current]::setSStatus} msg]} {
                    srvLog [namespace current] Error $msg
                }
                # Das ist notwendig:
	            ::WSServer::wsClientKill $clientsocket
            }
	        default {
				srvLog $clientsocket Info "WS-Connection unknown message type: %s" $type
                   # Kein Handlungsbedarf
	        }
	    }
        #}}}
    }; # proc handleClientMessage 

}; # namespace eval messages 

