#
# custom/kernel/jpeghocker.tcl
#
# Hocker-Livebild
#

namespace eval JPEGHocker {
    variable image_handlers [list]
    # Ablage für die erzeugten JPEG-Daten
    variable jpeg_image [druckbild::jpegdata {*}$::JPEGOPTIONS [lrepeat [expr 28*16] 0] 16 28]
    #TODO Overload Handler für die Weitergabe von Overload-Meldungen von DBLD2IMG


    # Callback für die Weitergabe des fertiggestellten JPEG-Bild
    # imagetype muß sitbones sein
    proc jpegFinished {imagetype} {
        variable image_handlers
        variable jpeg_image

        set jpeg_image [::tsv::get images $imagetype]
        srvLog [namespace current]::jpegFinished  Debug "${imagetype}: [string length $jpeg_image] Bytes"
        # Handler durchgehen
        foreach image_handler $image_handlers {
            $image_handler $imagetype
        }
    }


    # Erzeugung eines JPEGs aus einem Druckbild mit alternativen JPEG-Optionen
    # Die erzeugten JPEG-Daten werden von jpegFinished entgegengenommen.
    # @param druckbild          Druckdaten
    # @param n_rows             Anzahl Zeilen
    # @param n_cols             Anzahl Spalten
    # @param alt_jpegoptions    abweichende JPEG-Options (Liste)
    #   -resolution <ppp>       Pixel pro Meßpunkt
    #   -grid no|solid|dotted   Gitter
    #   -frame <pixels>         Rahmenstärke
    #   -quality <prozent>      JPEG-Qualität
    #   -maximum <max>          Maximalwert (falls nicht der tatsächliche)
    proc createJPEG {druckbild n_rows n_cols {alt_jpegoptions {}} } {; #{{{
        ::DBLD2IMG::startJPEG [namespace current]::jpegFinished $druckbild $n_rows $n_cols sitbones $alt_jpegoptions
        #}}}
    }; # proc createJPEG 


    # Weiteren Handler hinzufügen
    # @param cb_image_handler   Name der Callbackprozedur
    proc addImageHandler {cb_image_handler} {; #{{{
        variable image_handlers

        # Vorsichtshalber prüfen, ob es den schon gibt
        if {[lsearch $image_handlers $cb_image_handler] < 0} {
            lappend image_handlers $cb_image_handler
            srvLog [namespace current]::addImageHandler Debug "$cb_image_handler added"
        } else {
            srvLog [namespace current]::addImageHandler Debug "$cb_image_handler already added"
        }
        #}}}
    }; # proc addImageHandler 


    # Handler entfernen
    proc removeImageHandler {cb_image_handler} {; #{{{
        variable image_handlers

        set i [lsearch $image_handlers $cb_image_handler]
        if {$i >= 0} {
            set image_handlers [lreplace $image_handlers $i $i]
            srvLog [namespace current]::removeImageHandler Debug "$cb_image_handler entfernt"
        } else {
            srvLog [namespace current]::removeImageHandler Warn "$cb_image_handler nicht gefunden"
        }
        #}}}
    }; # proc removeImageHandler 


    #TODO Overload ?
    # Solange die ursprüngliche Bildfrequenz beibehalten wird, kann Overload nur auftreten,
    # wenn parallel die Satteldruckanalyse läuft.


    # Modul-Initialisierung
    proc init {} {
        # Anmelden bei der JPEG-Generierung
        #TODO? ::DBLD2IMG::addOverloadHandler [namespace current]::jpegOverload
    }

}; # namespace eval JPEGHocker

set mod_loaded JPEGHocker

