# HTTP-Domäne /infos
#
# Informationen zum Stationsdaemon als JSON String
#

namespace eval infos {

    set REQUESTLOGLEVEL "Info"
	
    namespace eval vmkstationd_conf {}

    # Sammelt Informationen über die Velobox und liefert sie als JSON Objekt aus.
    proc handleClientRequest {clientsocket {query {}} } {; #{{{
		upvar #0 clientcontext$clientsocket context
		
        # Infos zusammentragen
        set velobox [dict create]
        set vmkstationd_conf::STATION_NR 0; # vmkstationd nicht installiert (oder nicht registrierte Station)
        set vmkstationd_conf::WS_URL ""
        set vmkstationd_conf::PORT $::CONF_PORT
        if {[file exists /usr/local/etc/vmkstationd.conf]} {; # vmkstationd  Konfiguration einlesen
            namespace eval vmkstationd_conf {
                catch {source /usr/local/etc/vmkstationd.conf}
            }
        }
        dict set velobox STATION_NR $vmkstationd_conf::STATION_NR
        if {[file exists /usr/local/etc/velobox.conf]} {; # Velobox Konfiguration einlesen
            set fd [open /usr/local/etc/velobox.conf r]
            while {[gets $fd line] >= 0} {
                if {[regexp {^([A-Za-z0-9]+) *= *(.*$)} $line match key value]} {
                    set value [string trim $value]
                    if {[string length $value] >= 2} {
                        if {"[string index $value 0]" == "\"" && "[string index $value end]" == "\""} {
                            set value [string range $value 1 end-1]
                        }
                    }
                    dict set velobox $key $value
                }
            }
            close $fd
        }
        set vmkstationd [dict create "VERSION" $::VERSION]
        dict set vmkstationd WS_URL $vmkstationd_conf::WS_URL
        dict set vmkstationd PORT $vmkstationd_conf::PORT
        set apps [dict create]
        foreach {appcode} [dict keys $::apps::apps_loaded] {
            set app [dict create "VERSION" "0.0.0"]
            if {[info exists ::apps::${appcode}::VERSION]} {
                dict set app VERSION [set ::apps::${appcode}::VERSION]
            }
            dict set apps $appcode $app
        }
        set htdocs [dict create]
        if {[file exists ${::dir}/htdocs/htdocs.json]} {; # Spezifikation der htdocs einlesen
            set fd [open ${::dir}/htdocs/htdocs.json r]
            set json_htdocs [read $fd]
            close $fd
            if {[catch {set htdocs [::json::json2dict $json_htdocs]} result]} {
                srvLog [namespace current]::handleClientRequest Error $result
            }
        } else {
            srvLog [namespace current]::handleClientRequest Warn "${::dir}/htdocs/htdocs.json not found"
        }
        # Umbau in JSON
        # velobox
        set json_infos ""
        append json_infos "\"velobox\": {"
        set sep ""
        dict for {key value} $velobox {
            append json_infos "$sep\"$key\": "
            if {"$key" == "HARDWARE"} {; # Liste
                set hardware [split $value {, }]
                append json_infos "\["
                set sepp ""
                foreach {komponente} $hardware {
                    append json_infos "${sepp}\"$komponente\""
                    set sepp ", "
                }
                append json_infos "\]"
            } else {; # Einfacher Wert
                append json_infos "\"$value\""
            }
            set sep ", "
        }
        append json_infos "}"; # Abschluß "velobox"
        # vmkstationd
        append json_infos ", \"vmkstationd\": {"
        set sep ""
        dict for {key value} $vmkstationd {
            append json_infos "$sep\"$key\": "
            append json_infos "\"$value\""
            set sep ", "
        }
        append json_infos "}"; # Abschluß "vmkstationd"
        append json_infos ", \"apps\": {"
        # apps
        set sep ""
        dict for {appcode values} $apps {
            append json_infos "$sep\"${appcode}\": {"
            set sepp ""
            foreach {key value} $values {
                append json_infos "$sepp\"$key\": \"$value\""
                set sepp ", "
            }
            set sep ", "
            append json_infos "}"; # Abschluß "$appcode"
        }
        set sep ""
        append json_infos "}"; # Abschluß "apps"
        append json_infos ", \"htdocs\": {"
        set sep ""
        dict for {key value} $htdocs {
            append json_infos "$sep\"$key\": \"$value\""
            set sep ", "
        }
        append json_infos "}"; # Abschluß "htdocs"
        set context(contenttype) "application/json; charset=utf-8"
		return "{$json_infos}"
        #}}}
    }; # proc handleClientRequest
}

