#!/bin/bash
#
# setup_by_vlbupdate.sh
#
# Dieses Skript bringt das Installationspaket von vmkstationd
# an die richtige Stelle, entpackt es und führt das Setup aus.
# Es wird von .../vmkstationd3/devel/create_sup4vlb_tar_gz.sh gemäß Konventionen umbenannt und
# im Downloadpaket für vlbupdate verpackt,
# um schließlich von vlbupdate auf der Velobox ausgeführt zu werden.
#
# Historie:
#   01.11.2023 Siegmar Müller   Letze Korrektur => Fertig
#

# Bei hier vorgegebenem Installationspaket wird dieses ohne Rückfrage installiert.
INSTALLPACKAGE=""
# Das kann zu Testzwecken vorübergehend geändert werden:
SETUPDIR="/usr/local"

# Hilfe ausgeben
help() {
    echo
    echo "vmkstationd setup ausführen:"
    echo
    echo "Aufruf: $0 -h|<installpackage>"
    echo "Optionen:"
    echo "-?    Hilfe ausgeben und beenden"
    if [ $UID -ne 0 ]; then
        echo "(Die Ausführung erfordert root-Rechte.)"
    fi
    echo
}

[ "$INSTALLPACKAGE" == "" -a $# -eq 0 ] && { help; exit 0; }
[ $# -gt 0 ] && INSTALLPACKAGE=$1
[ ! -f $INSTALLPACKAGE ] && { echo "Installpackage '$INSTALLPACKAGE' not found."; exit 1; }

# Ausführung als root
if [ $UID -ne 0 ]; then
    echo "Das Skript benötigt 'root' Rechte."
    su -c "$0 $*"
    exit $?
fi

cp -v $INSTALLPACKAGE $SETUPDIR || exit 1
cd $SETUPDIR || exit 1
tar -xvf $INSTALLPACKAGE || exit 1
[ ! -x ${INSTALLPACKAGE%.tar.gz}/setup/setup.sh ] && { echo "setup.sh for vmkstationd not found."; exit 1; }
# setup.sh ausführen
${INSTALLPACKAGE%.tar.gz}/setup/setup.sh >> /var/local/log/vlbupdate.log
rm $INSTALLPACKAGE && echo "$INSTALLPACKAGE removed."

# Weitere Setups entsprechend der vorhandenen Hardware

if [ ! -f /usr/local/etc/velobox.conf ]; then
    echo "/usr/local/etc/velobox.conf not found. => no more setups"
    exit 0
fi

# Hardwarekomponenten durchgehen
for HW in `sed -n '/^HARDWARE=/{s/.*=//;s/,/ /gp}' /usr/local/etc/velobox.conf`; do
    case $HW in
        PIEPSER)
            echo "PIEPSER => kein spezifisches Setup erforderlich"
            ;;
        JIT35)
            echo "Lokales Display => Client(s) dafür installieren"
            [ ! -x ${INSTALLPACKAGE%.tar.gz}/setup/setup_clients.sh ] && { echo "setup_clients.sh for JIT35 not found."; exit 1; }
            # setup_clients.sh ausführen
            ${INSTALLPACKAGE%.tar.gz}/setup/setup_clients.sh
            ;;
    esac
done

echo "$0 erfolgreich beendet."

