#!/bin/bash
#
# setup_wlan.sh
#
# Velobox3
# Zusätzliche(r) WLAN-Treiber
#
#
# Historie:
#   15.03.2024  Siegmar Müller  Begonnen
#

# Voller Pfad des Startverz. mit '/' am Ende
SETUP_DIR="$(cd $(dirname $0) > /dev/null 2>&1; pwd -P)/"

LOGFILE=/var/local/log/vlbsetup.log
if [ ! -d `dirname $LOGFILE` ]; then
    echo "Das Verzeichnis /var/local/log/ existiert nicht."
    echo "Wurde setup.sh ausgeführt?"
    exit 1
fi

# Hilfe ausgeben
help() {
    echo
    echo "Velobox Installation zusätzlicher WLAN-Treiber:"
    echo
    echo "Aufruf: $0 [<optionen>]"
    echo "Optionen:"
    echo "-?        Hilfe ausgeben und beenden"
    if [ $UID -ne 0 ]; then
        echo "(Die Ausführung erfordert root-Rechte.)"
    fi
    echo
}

# Optionen aus der Kommandozeile holen.
while getopts ? OPTION; do
    case $OPTION in
        ?) help; exit 0;;
    esac
done

# Ausführung als root
if [ $UID -ne 0 ]; then
    echo "Das Skript benötigt 'root' Rechte."
    su -c "$0 $*"
    exit $?
fi

if [ -f $LOGFILE ]; then
    echo -e "\n-------------------------------------------------------------------------------" >> $LOGFILE
fi
# Start
echo
echo "$0 `date '+%d.%m.%Y %H:%M:%S'`" | tee -a $LOGFILE
echo

# Ausgabe von Logmeldungen in der Form:
#   echo "Meldung" | tee -a $LOGFILE
log() {
    echo "$*" | tee -a $LOGFILE
}

# Setup bei Fehler abbrechen
#   cancelSetup [<exit_status>]
# Ohne Angabe von <exit_status> wird mit Status 0 abgebrochen.
# Bei <exit_status> 0 geht es weiter.
cancelSetup() {
    if [ $# -eq 0 ]; then
        log "$0 abgebrochen."
        exit 0
    fi
    if [ $1 -ne 0 ]; then
    	log "$0 mit Status $1 abgebrochen"
    	exit $1
    fi
} # cancelSetup()


# Installierte Hardware in velobox.conf eintragen
# Aufruf: updateConf <hardware>
updateConf() {
    if [ ! -f /usr/local/etc/velobox.conf ]; then
        echo "/usr/local/etc/velobox.conf existiert nicht => Eintrag der Hardware ist unmöglich." 
        return 1
    fi
    if `grep -q '^HARDWARE=.*'$1 /usr/local/etc/velobox.conf`; then
        echo "$1 ist bereits als Hardwarekomponente in /usr/local/etc/velobox.conf eingetragen."
    else
        # <hardware> ist nicht eingetragen
        if `grep -q '^HARDWARE=' /usr/local/etc/velobox.conf`; then # $HARDWARE muß modifiziert werden
            cp -v /usr/local/etc/velobox.conf /usr/local/etc/velobox.conf~
            sed '/^HARDWARE=[^ ]/s/$/,'$1'/;/^HARDWARE= *$/s/= */='$1'/' /usr/local/etc/velobox.conf~ > /usr/local/etc/velobox.conf
        else # $HARDWARE ist (merkwürdigerweise) gar nicht definiert.
            # => anhängen
            echo -e "\nHARDWARE=$1" >> /usr/local/etc/velobox.conf
        fi
        echo "$1 als Hardwarekomponente in /usr/local/etc/velobox.conf eingetragen."
    fi
} # updateConf()


# Wenn nötig, Kernel-Header nachinstallieren
for PACKAGE in raspberrypi-kernel-headers bc; do
    dpkg-query -l $PACKAGE 2>&1 > /dev/null
    if [ $? -ne 0 ]; then
        log "$PACKAGE ist nicht installiert => installieren"
        apt-get install $PACKAGE 2>&1 | tee -a $LOGFILE
        [ ${PIPESTATUS[0]} -ne 0 ] &&  cancelSetup 1
    fi
done

if [ ! -f 88x2bu-20210702-main.zip ]; then
    log "88x2bu-20210702-main.zip nicht gefunden."
    cancelSetup 1
fi

unzip 88x2bu-20210702-main.zip 2>&1 | tee -a $LOGFILE
[ ${PIPESTATUS[0]} -ne 0 ] &&  cancelSetup 1
cd 88x2bu-20210702-main
./install-driver.sh NoPrompt 2>&1 | tee -a $LOGFILE
[ ${PIPESTATUS[0]} -ne 0 ] &&  cancelSetup 1


updateConf WLAN_88x2bu || exit 1

log "Setup erfolgreich beendet."

