// JavaScript Kode zu index.tcls


console.log ("Hole index.js ....");

// vlbconf sollte von index.tcls bereits gesetzt sein.
if (typeof vlbconf == undefined) {// doch nicht
    // => Fehler verweiden
    var vlbconf = new Object(); //TODO LANG en
}


var ws_url = "ws://" + window.location.hostname + ":" + window.location.port + "/vlbupdate";

// Die Websocket Verbindung
var conn;

// Die verfügbaren Updates (Dateinamen der Downloads)
var updates = new Array();
// Die noch auszuführenden Updates (Dateinamen der Downloads)
var next_updates = new Array();
var update_started = false;
// Die ausgeführten Updates (Dateinamen der Downloads)
var updates_done = new Array();
// Es handelt sich um ein individuelles Update
var update_is_individual = false;


// Websocket Daten sind eingegangen.
function handleWSMessage (wsmessage) {//{{{
    let msg;
    let html = "";

    try {
         msg = JSON.parse (wsmessage);
    } catch (error) {
        console.log ("Kein gültiger JSON-String: \"" + wsmessage + "\"");
        return;
    }
    console.log (wsmessage);
    if (msg.wsevent == "infos") {//{{{
        let infos = msg.infos;
        let is_velobox = false;
        let is_apps = false;

        html = "<h3>Infos:</h3>";        
        html += "<details>";        
        html += "<summary>[show/hide]</summary>";        
        html += "<dl>";        
        for (let level in infos) {
            is_velobox = (level == "velobox");
            is_apps = (level == "apps");
            html += "<dt>"+level+":</dt>";
            html += "<dd>";
            let def = infos[level];
            html += "<table>";
            for (let key in def) {
                html += "<tr><td>"+key+"</td><td>";
                if (is_velobox && (key == "HARDWARE")) {
                    // Sonderbehandlung für HARDWARE in velobox
                    html += "<dl>";
                    for (let i in def[key]) {
                        html += "<dd>"+def[key][i]+"</dd>";
                    }
                    html += "</dl>";
                } else if (is_apps) {
                    // Sonderbehandlung für Apps
                    let app = def[key];
                    html += "<dl><table>";
                    for (let prop in app) {
                        html += "<tr><td>"+prop+"</td><td>"+app[prop]+"</td></tr>";
                    }
                    html += "</table></dl>";
                } else {
                    html += def[key];
                }
                html += "</td></tr>";
            }
            html += "</table>";
            html += "</dd><br/>";
        }
        html += "</dl>";        
        html += "</details>";        
        document.getElementById("infos").innerHTML = html;
        //}}}
    } else if (msg.wsevent == "warning") {// {{{
        let warning = msg.warning;
        let reason = msg.reason.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        html = "<h3>Warning</h3>"
        if (warning == "no_infos") {
            html += "No infos available: ";
            {// Statt Infos velobox.conf mit Objekt vlbconf bauen und anzeigen
            let html = "<h3>velobox.conf</h3>";
            html += "<table>";
            for (let key in vlbconf) {
                html += "<tr><td>"+key+"</td><td>"+vlbconf[key]+"</td></tr>";
            }
            html += "</table>";
            document.getElementById("infos").innerHTML = html;
            }
        }
        if (reason == "not_installed")
            html += "vmkstationd is not installed";
        else if (reason == "stopped")
            html += "vmkstationd not started or stopped";
        else
            html += "error in vmkstationd";
        document.getElementById("message").innerHTML = html;
        //}}}
    } else if (msg.wsevent == "error") {//{{{
        let error = msg.error;
        let message = msg.message.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        html = "<h3>Error:</h3>"
        if (error == "cant_query_updates")
            html += "Can't query updates from server.<br/>";
        else
            if (update_started) {// Update fehlgeschlagen
                // Meldung entsprechend ergänzen
                error = error+" (update failed)";
                update_started = false;
            }
            html += error+":<br/>";
        html += "("+message+")<br/>";
        document.getElementById("message").innerHTML = html;
        //}}}
    } else if (msg.wsevent == "updates") {//{{{
        updates = msg.updates;
        html = "<h3>"+updates.length+" Updates:</h3>";        
        html += "<table>";        
        for (let i in updates) {
            html += "<tr>";
            html += "<td>&nbsp;"+updates[i].software+"&nbsp;</td>";
            html += "<td>&nbsp;"+updates[i].file+"&nbsp;</td>";
            html += "<td>&nbsp;"+updates[i].TO+"&nbsp;</td>";
            html += "<td>&nbsp;"+updates[i].comment+"&nbsp;</td>";
            html += "</tr>";
        }
        html += "</table>";        
        if (updates.length > 0) {
            html += "<INPUT type=\"button\" onclick=\"executeUpdates()\" value=\"Update!\"/><BR/>";

        }
        document.getElementById("updates").innerHTML = html;
        //}}}
    } else if (msg.wsevent == "updating") {//{{{
        let message = msg.message;
        html = "<h3>Update started:</h3>"
        html += msg.file+"<br/>";
        document.getElementById("message").innerHTML = html;
        //}}}
    } else if (msg.wsevent == "updated") {//{{{
        let message = msg.message;
        html = "<h3>Update(s) done:</h3>"
        updates_done.push (msg.file);
        for (let i in updates_done)
            html += updates_done[i]+"<br/>";
        update_started = false;
        executeNextUpdate (); // Nächstes Update anschieben, falls weitere.
        document.getElementById("message").innerHTML = html;
        //}}}
    } /* else {
	        document.getElementById("message").innerHTML = wsmessage.replace(/</g,"&lt;").replace(/>/g,"&gt;");
    }
    */
    //}}}
} // function handleWSMessage ()


// Websocket Verbindung einrichten
function connect () {//{{{
    if (window["WebSocket"]) {
        if (typeof conn == "object") {
            if (conn.readyState == WebSocket.OPEN)
                conn.close();
        }
        // Verbindung herstellen
        try {
            // Der Server erwartet wenigstens ein (Sub)Protokoll, auch wenn das nicht benutzt wird.
            conn = new WebSocket(ws_url, "dummy");
        } catch (error) {
            console.error ("Couldn't connect to " + ws_url + ": " + error);
            return;
        }
        switch (conn.readyState) {
            case WebSocket.CONNECTING: // Die Verbindung ist noch nicht hergestellt.
                console.log ("WebSocket-Verbindung wird hergestellt.");
                conn.onopen = function (evt) {
                    console.log ("WebSocket-Verbindung ist hergestellt.");
                    conn.onclose = function (evt) {
                        console.log ("WebSocket-Verbindung wurde geschlossen.");
                    };
                };
                conn.onclose = function (evt) {
                    console.log ("WebSocket-Verbindung konnte nicht hergestellt werden.");
                };
                break;
            case WebSocket.OPEN:       // Verbindung ist hergestellt und bereit darüber zu kommunizieren.
                console.log ("WebSocket-Verbindung ist bereit.");
                break;
            case WebSocket.CLOSING:    // Verbindung ist im Prozess des Schließens.
            case WebSocket.CLOSED:     // Die Verbindung konnte nicht hergestellt werden.
                console.log ("WebSocket-Verbindung konnte nicht hergestellt werden.");
                break;
        }
        // Eingetroffene Meldung vom Server bearbeiten
        conn.onmessage = function (evt) {
            handleWSMessage (evt.data);
        };
    } else {
        console.log ("WebSocket ist in diesem Browser nicht verfügbar");
    }

    //}}}
} // connect()


// Kommando an den Websocket Server senden
function sendCommand (command) {
    if (typeof conn == "object" && conn.readyState == WebSocket.OPEN) {
        conn.send (command);
    } else {
        alert ("Not connected.");
    }
}


// Das nächste Update ausführen, sofern es noch eines gibt.
function executeNextUpdate () {
    if (next_updates.length == 0) {
        if (update_is_individual) {// => (vorläufig) keine weiteren Updates
            update_is_individual = false;
        } else {
            // verbleibende Updates abrufen
            sendCommand ("query updates");
        }
        return;
    }
    let filename = next_updates.shift().file;
    update_started = true;
    sendCommand ("update " + filename);
}


// Die verfügbaren Updates ausführen
function executeUpdates () {
    if (updates.length == 0)
        return;
    updates_done.length = 0;
    console.log ("Execute " + updates.length + " updates.");
    next_updates = JSON.parse(JSON.stringify(updates));
    executeNextUpdate ();
}


// Das individuelle Update ausführen
function executeIndividualUpdate () {
    let filename = document.getElementById("filename").value;
    if (filename == "")
        return;
    console.log ("Execute update " + document.getElementById("filename").value);
    update_started = true;
    update_is_individual = true;
    updates_done.length = 0;
    sendCommand ("update " + document.getElementById("filename").value);
}


window.onload = function (evt) {
    connect ();
};

console.log ("index.js geholt.");
