#! /bin/bash
#
# vlbupdate.sh
#

### BEGIN INIT INFO
# Provides:          vlbupdate
# Required-Start:    $local_fs $remote_fs $network $syslog $named
# Required-Stop:     $local_fs $remote_fs $network $syslog $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# X-Interactive:     true
# Short-Description: Velobox Updateserver
# Description:       Start des Updateservers
#  Dieses Skript startet den Updateserver einer Velometrik-Arbeitsstation.
### END INIT INFO

# Das Skript nach /etc/init.d kopieren und mit
#$ update-rc.d vlbupdate.sh defaults
# scharf schalten.


VLBUPDATE=/usr/local/vlbupdate/vlbupdate.tcl
LOGDIR=/var/local/log


# PID des laufenden Prozesses oder leer.
PID=`pgrep -f "/usr/bin/tclsh $VLBUPDATE"`

case "$1" in
    start)
        if [ -n "$PID" ]; then
            echo "vlbupdated laeuft bereits. PID=${PID}."
            exit
        fi
        if [ ! -d $LOGDIR ]; then
            mkdir -p $LOGDIR
        fi
        if [ -d /usr/local/vlbupdate_next ]; then # Eine neue Version wurde bereitgestellt.
            # => Links anpassen
            rm -f /usr/local/vlbupdate_last # Das wird mit einer neuen Version obsolet.
            if [ -d /usr/local/vlbupdate ]; then # Eine aktuelle Version existiert.
                # Die wird zur vorhergehenden.
                mv /usr/local/vlbupdate /usr/local/vlbupdate_last
            fi
            # Die neue Version starten.
            mv /usr/local/vlbupdate_next /usr/local/vlbupdate
        elif [ -d /usr/local/vlbupdate_last ]; then # Start mit neuer Version fehlgeschlagen
            # => Zur Vorversion zurückgehen
            rm -f /usr/local/vlbupdate
            mv /usr/local/vlbupdate_last /usr/local/vlbupdate
        fi
        # Die (nunmehr) aktuelle Version starten.
        cd $LOGDIR
        $VLBUPDATE -L ${LOGDIR}/vlbupdate.log &
        # Nach erfolgreichem Start löscht $VLBUPDATE /usr/local/vlbupdate_last.
        ;;
    status)
        if [ -n "$PID" ]; then
            echo "vlbupdate laeuft. PID=${PID}."
            exit 0
        else
            echo "vlbupdate laeuft nicht."
            exit 3
        fi
        ;;
    stop)
        if [ -z "$PID" ]; then
            echo "vlbupdate laeuft nicht."
        else
            # Es müssen auch die Childprozesse gekillt werden.
            CHILDPIDS=`pgrep -P $PID`
            for CHILDPID in $CHILDPIDS; do
                kill $CHILDPID 
                wait $CHILDPID 
                echo "vlbupdate child process $CHILDPID beendet."
            done
            kill $PID
            if [ $? -eq 0 ]; then
                echo "vlbupdate beendet."
            else
                echo "vlbupdate konnte nicht beendet werden."
            fi
        fi
        ;;
    restart)
        $0 stop
        $0 start
        ;;
    *)
        echo "Usage: $0 {start|status|stop|restart}"
        exit 1
        ;;
esac

