#!/bin/bash
#
# Vorlage für Updateskripte TODO löschen
#TODO Dateiname
#
# Velometrik GmbH
#
# Historie:
#   31.07.2023 Siegmar Müller   Begonnen
#

TESTMODE=false

# Ausgangsversion
VERSION_FROM_MIN="4.0.0"
# Zielversion, die am Ende installiert sein wird. (evtl. mit Vorläufigkeitsanhang)
# (In vlbupdate.json wird dieser Vorläufigkeitsanhang nicht eingetragen!)
VERSION_TO="4.0.0_X20230801"

# Das Skript wird in dem Verzeichnis ausgeführt, in dem es sich befindet.
cd `dirname $0`
#TODO Test:
echo "Das hammer zum Verteilen:"
ls

# Das vlbupdate ruft das Updateskript ohne Argumente auf.
# Die Hilfe und eventuelle Argumente sind deshalb nur zum Testen gedacht.

# Hilfe ausgeben
help() {
    echo
    echo "Velobox Update:"
    echo
    echo "Aufruf: $0 [<optionen>]"
    echo "Optionen:"
    echo "-t            Testmodus"
    echo "-?            Hilfe ausgeben und beenden"
    if [ $UID -ne 0 ]; then
        echo "(Die Ausführung erfordert i.a. root-Rechte.)"
    fi
    echo
}

# Optionen aus der Kommandozeile holen.
while getopts t? OPTION; do
    case $OPTION in
        t) TESTMODE=true;;
        ?) help; exit 0;;
    esac
done


# Setup bei Fehler abbrechen
#   cancelUpdate [<exit_status>]
# Ohne Angabe von <exit_status> wird mit Status 0 abgebrochen.
# Bei <exit_status> 0 geht es weiter.
# (Das ermöglicht den Aufruf
#       cancelUpdate $?
#  ohne vorhergehenden Test.)
cancelUpdate() {
    if [ $# -eq 0 ]; then
        echo "$0 interrupted."
        exit 0
    fi
    if [ $1 -ne 0 ]; then
    	echo "$0 interrupted with status $1."
    	exit $1
    fi
} # cancelUpdate()


# Ist <version1> <= <version2>a?
# (ohne Vorläufigkeitsanhang)
#TODO Dok fertig
versionLE() {
    #echo "versionLE $@"
    #echo "$# Argumente"
    mmr1=`echo $1 | sed 's/\./ /g'`
    mmr2=`echo $2 | sed 's/\./ /g'`
    for n in 1 2 3; do
        v1=`echo $mmr1 | cut -d ' ' -f $n`
        v2=`echo $mmr2 | cut -d ' ' -f $n`
        test $v1 -eq $v2 && continue
        test $v1 -lt $v2 && return 0
        test $v1 -gt $v2 && return 1
    done
    return 0
} # versionLE()


echo "Start: $0 $@"
echo

# Aktuelle Version ermitteln
if [ ! -f /usr/local/etc/velobox.conf ]; then
    echo "Can't update: /usr/local/etc/velobox.conf doesn't exit."
    cancelUpdate
fi
# Installierte und Zielversion in Hauptteil und Vorläufigkeitsanhang zerlegen
VERSION=`sed -nE '/^VERSION/s/^[^=]+= *(.*)$/\1/p' /usr/local/etc/velobox.conf`
PRELIMINARY=`echo $VERSION | sed -E '/_/s/^.*_(.*)$/\1/'`
VERSION=`echo $VERSION | sed -E '/_/s/_.*$//'`
PRELIMINARY_TO=`echo $VERSION_TO | sed -E '/_/s/^.*_(.*)$/\1/'`
VERSION_TO=`echo $VERSION_TO | sed -E '/_/s/_.*$//'`
echo "Try update from version ${VERSION}_${PRELIMINARY} to ${VERSION_TO}_${PRELIMINARY_TO}."

# Prüfen, ob Update notwendig/möglich ist
if [ "$VERSION" == "$VERSION_TO" ]; then
    if [ -z "$PRELIMINARY" ]; then # Installierte Version ist nicht vorbereitend
        # => Kein Update
        echo "Update not necessary."
        cancelUpdate
    fi
    # Installierte Version ist vorbereitend.
    if [ ! -z "$PRELIMINARY_TO" ]; then # Neue Version ist auch vorbereitend.
        if [ "$PRELIMINARY" == "$PRELIMINARY_TO" ]; then
            # => Kein Update
            echo "Update not necessary."
            cancelUpdate
        else # Vorläufigkeitsanhang berücksichtigen:
            #TODO Das muß im konkreten Fall ggf. angepaßt werden.
            #X[<date>]
            #A[<date>]
            #B<nr>[U[<date>]]
            #P<nr>[U[<date>]]
            #U[<date>]
            # (Das verwendete Datumsformat YYYYMMDD gestattet einen einfachen numerischen Vergleich.)
            # Bei X, A, U das Datum vergleichen
            if `echo $PRELIMINARY_TO | grep -q '^[XAU]'`; then # Unfertige Versionen vergleichen
                # => Datum vergleichen
                date=`echo $PRELIMINARY | sed -E 's/.([0-9]*)$/\1/'`
                date_to=`echo $PRELIMINARY_TO | sed -E 's/.([0-9]*)$/\1/'`
                if [ -z "$date" -o -z "$date_to" ]; then # unklare Situation
                    #TODO ggf. auf konkreten Fall anpassen
                    echo "Can't compare versions."
                    cancelUpdate
                fi
            else # Beta oder Prerelease
                #TODO Vorlage Vergleich für B und P
                echo "Comparison with beta- and prereleases not implemented."
                cancelUpdate
            fi
        fi
    else # Neue Version ist final.
        : # => installieren
    fi
elif `versionLE $VERSION $VERSION_TO`; then 
    : # Update wird ausgeführt
else # $VERSION" > "$VERSION_TO
    # => Kein Update
    echo "Can't dowgrade."
    cancelUpdate
fi

echo "`date '+%d.%m.%Y %H:%M:%S'` Start update ..."
echo

#TODO Hier das eigentliche Update einbauen

if `$TESTMODE`; then
    echo "Testmode => keep current version."
else
    #TODO Neue Version in velobox.conf eintragen
    echo "Set new version."
fi

echo
echo "`date '+%d.%m.%Y %H:%M:%S'`: Update successfully finished."

