#!/usr/bin/tclsh
#
# Velometrik Velobox' lokaler Updateservice
#
# Steuert Updates auf der Velobox
#
# Author: Siegmar Müller
#
# Historie:
# 04.08.2023 Siegmar Müller Begonnen
# 09.08.2023 Siegmar Müller Grundfunktionen fertig
#


set VERSION 1.0.0_U20240124; # modified by create_vlbupdate_tar_gz.sh

# set ::dir Basisverzeichnis
set ::dir [file dirname [info script]]
if {[string equal -length 1 $::dir "."]} {
    set dir "$env(PWD)[string range $::dir 1 end]"
}

set ::BINDIR "$::dir/bin/[exec uname -m]"

# Loglevels (wie bei websocket zuzügl. debug2)
set ::LOGLEVELS [list "error" "warn" "notice" "info" "debug" "debug2"]
set ::LOGLEVEL "info"
set ::LOGLEVEL "debug"; #TODO auskommentieren
set ::CONF_LOGFILE "/var/local/log/vlbupdate.log"

exec mkdir -p [file dirname /var/local/log/vlbupdate.log]
if {[file exists $::CONF_LOGFILE]} {
    # Existierendes Logfile sichern
    file copy -force $::CONF_LOGFILE ${::CONF_LOGFILE}~
    #TODO Altes Logfile löschen
}


# Ausgabe von Logmeldungen
# @param sock       Absender der Logmeldung
# @param loglevel   Loglevel wie bei ::websocket
# @param format     Einfacher oder (printf) Formatstring für TCL-format
# @param args       Argumente gemäß Formatstring
proc ::srvLog {sock loglevel format args} {; #{{{
    set i_loglevel [lsearch $::LOGLEVELS $::LOGLEVEL]
    set i_msglevel [lsearch -nocase $::LOGLEVELS $loglevel]
    if {$i_msglevel <= $i_loglevel} {
        if {$i_msglevel < 0} {; # unbekanntes Loglevel
            append loglevel " (unknown loglevel)"
        }
        if {[llength $args] == 0} {
            set logmsg "[clock format [clock seconds]] $sock $loglevel: $format"
        } else {
            set logmsg "[clock format [clock seconds]] $sock $loglevel: [format $format {*}$args]"
        }
           if {[catch {
               set fd [open $::CONF_LOGFILE "a"]
               puts $fd $logmsg
               close $fd
           } error]} {
               puts stderr $error
               puts stderr $logmsg
           }
    }
    #}}}
}; # proc ::srvLog 

# Leerzeile zum Neustart
set fd [open $::CONF_LOGFILE "a"]
puts $fd ""
close $fd
srvLog {vlbupdate.tcl} Notice "Start vlbupdate"

if {![file isdirectory $::BINDIR]} {
    srvLog {vlbupdate.tcl} Warn "::BINDIR $::BINDIR doesn't exist."
}

# Die Kommandos für den lokalen Updateservice
namespace eval ::vlbupdate {

    if {![file exists $::dir/custom/commands.tcl]} {
        puts stderr "$::dir/custom/commands.tcl existiert nicht."
        exit 1
    }
    if {[catch {source $::dir/custom/commands.tcl} msg]} {
        puts stderr "Error loading $::dir/custom/commands.tcl: $msg"
        exit 1
    }
}


# HTTP/WS-Server holen
if {[file exists $::dir/lib/wsserver.tcl]} {
    source $::dir/lib/wsserver.tcl
} else {
    puts stderr "$::dir/lib/wsserver.tcl existiert nicht."
    exit 1
}


if {[catch {
    # HTTP/WS-Server starten
    srvLog {vlbupdate.tcl} Notice "Starte WSServer ..."
    ::WSServer::start "port 8080 doc_root $::dir/htdocs default index.tcls"
    srvLog {vlbupdate.tcl} Notice "... gestartet."
} errmsg]} {
    srvLog {::kernel} Error "::WSServer nicht gestartet: $errmsg"
    exit 1
}

# Behandlung von Hintergrundfehlern
# Wird aufgerufen, wenn der Interpreter (bei vwait) in einen vorher nicht aufgefangenen Fehler läuft:
# @param msg    Meldung vom TCL-Kern
proc bgerror {msg} {
    global errorInfo

    srvLog bgerror Error "$msg\n$errorInfo"
}; # proc bgerror


# Deamon erfolgreich gestartet
# Falls es einen Link auf eine Fallback-Version gibt, wird der nicht mehr gebraucht.
if {[file exists /usr/local/vlbupdate_last]} {
    file delete /usr/local/vlbupdate_last
    srvLog {} Notice "/usr/local/vlbupdate_last gelöscht."
}

vwait forever

